package app.latexcards.models.profiles

import dev.kaccelero.annotations.ModelProperty
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.IUser
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable

@Serializable
data class Profile(
    @ModelProperty("id")
    @Schema("Id of the profile", "123abc")
    override val id: String,
    @ModelProperty("string")
    @Schema("Secret of the profile, only given when creating it", "123abc")
    val secret: String?,
    @ModelProperty("string")
    @Schema("Username of the profile", "Nathan Fallet")
    val username: String,
    @ModelProperty("string")
    @Schema("Biography of the profile", "Hello, I'm Nathan Fallet, a software engineer.")
    val biography: String,
    @ModelProperty("string")
    @Schema("Image of the profile", "https://example.com/image.jpg")
    val image: String?,
    @Schema("Last login date of the profile", "2021-01-01T00:00:00Z")
    val lastLoginAt: Instant,
) : IModel<String, CreateProfilePayload, UpdateProfilePayload>, IUser
