package app.latexcards.repositories.profiles

import app.latexcards.models.auth.AuthToken
import app.latexcards.models.folders.ProfileFolder
import app.latexcards.models.folders.UpdateProfileFoldersPayload
import app.latexcards.models.profiles.*

interface IProfilesRemoteRepository {

    suspend fun get(id: String): Profile?
    suspend fun create(payload: CreateProfilePayload): Profile?
    suspend fun token(payload: CreateProfileTokenPayload): AuthToken?
    suspend fun refresh(payload: RefreshProfileTokenPayload): AuthToken?
    suspend fun update(id: String, payload: UpdateProfilePayload): Profile?
    suspend fun listFolders(id: String): List<ProfileFolder>
    suspend fun updateFolders(id: String, payload: UpdateProfileFoldersPayload)

}
