package app.latexcards.models.folders

import dev.kaccelero.annotations.ModelProperty
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class Folder(
    @ModelProperty("id")
    @Schema("Id of the folder", "123abc")
    override val id: UUID,
    @ModelProperty("string")
    @Schema("Name of the folder", "My folder")
    val name: String,
    @Schema("Id of the parent folder", "123abc")
    val parentFolderId: UUID?,
    @Schema("Id of the profile the folder is in", "123abc")
    val profileId: UUID?,
    @Schema("Number of sub folders in the folder", "42")
    val foldersCount: Long,
    @Schema("Number of topics in the folder", "42")
    val topicsCount: Long,
) : IModel<UUID, CreateFolderPayload, UpdateFolderPayload>
