package app.latexcards.models.topics

import dev.kaccelero.annotations.ModelProperty
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.UUID
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable

@Serializable
data class Topic(
    @ModelProperty("id")
    @Schema("Id of the Topic", "123abc")
    override val id: UUID,
    @ModelProperty("string")
    @Schema("Name of the Topic", "My topic")
    val name: String,
    @Schema("Id of the Folder the topic is in", "123abc")
    val folderId: UUID?,
    @Schema("Id of the User the topic is in", "123abc")
    val userId: UUID?,
    @Schema("Last update date of the topic", "2021-01-01T00:00:00Z")
    val lastUpdatedAt: Instant,
    @Schema("Whether the topic is public (for profile and community listing)", "true")
    val public: Boolean,
    @Schema("Number of cards in the topic", "42")
    val cardsCount: Long,
) : IModel<UUID, CreateTopicPayload, UpdateTopicPayload>
