package app.latexcards.client

import app.latexcards.models.application.LaTeXCardsEnvironment
import app.latexcards.repositories.profiles.ProfilesRemoteRepository
import app.latexcards.repositories.topics.TopicsRemoteRepository
import dev.kaccelero.client.AbstractAPIClient
import dev.kaccelero.commons.auth.IGetTokenUseCase
import dev.kaccelero.commons.auth.ILogoutUseCase
import dev.kaccelero.commons.auth.IRenewTokenUseCase
import io.ktor.http.*

class LaTeXCardsClient(
    getTokenUseCase: IGetTokenUseCase,
    renewTokenUseCase: IRenewTokenUseCase,
    logoutUseCase: ILogoutUseCase,
    environment: LaTeXCardsEnvironment = LaTeXCardsEnvironment.PRODUCTION,
) : AbstractAPIClient(
    environment.baseUrl,
    getTokenUseCase,
    renewTokenUseCase,
    logoutUseCase
), ILaTeXCardsClient {

    override val topics = TopicsRemoteRepository(this)
    override val profiles = ProfilesRemoteRepository(this)

    override fun shouldIncludeToken(method: HttpMethod, path: String): Boolean {
        // Don't include token for refresh token endpoint (to avoid infinite loop)
        return path != "/api/v1/profiles/refresh"
    }

}
