package app.latexcards.models.cards

import dev.kaccelero.annotations.ModelProperty
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IChildModel
import dev.kaccelero.models.UUID
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable

@Serializable
data class Card(
    @ModelProperty("id")
    @Schema("Id of the card", "123abc")
    override val id: UUID,
    @Schema("Id of the topic the card is in", "123abc")
    val topicId: UUID,
    @ModelProperty("string")
    @Schema("Name of the card", "My card")
    val name: String,
    @ModelProperty("string")
    @Schema("Front text of the card", "Hello")
    val frontText: String?,
    @ModelProperty("string")
    @Schema("Back text of the card", "World")
    val backText: String,
    @ModelProperty("date")
    @Schema("Date of creation", "2024-01-01T00:00:00.000Z")
    val createdAt: Instant,
    @ModelProperty("date")
    @Schema("Date of last update", "2024-01-01T00:00:00.000Z")
    val lastSeenAt: Instant,
) : IChildModel<UUID, CreateCardPayload, UpdateCardPayload, UUID> {

    override val parentId: UUID
        get() = topicId

}
