package app.latexcards.models.cards

import dev.kaccelero.annotations.PayloadProperty
import dev.kaccelero.annotations.Schema
import kotlinx.datetime.Instant
import kotlinx.serialization.Serializable

@Serializable
data class UpdateCardPayload(
    @PayloadProperty("string")
    @Schema("Name of the card", "My card")
    val name: String,
    @PayloadProperty("string")
    @Schema("Front text of the card", "Hello")
    val frontText: String? = null,
    @PayloadProperty("string")
    @Schema("Back text of the card", "World")
    val backText: String,
    @PayloadProperty("date")
    @Schema("Date of last update", "2024-01-01T00:00:00.000Z")
    val lastSeenAt: Instant? = null,
)
