package app.latexcards.models.topics

import dev.kaccelero.annotations.ModelProperty
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import kotlinx.serialization.Serializable

@Serializable
data class Topic(
    @ModelProperty("id")
    @Schema("Id of the topic", "123abc")
    override val id: String,
    @ModelProperty("string")
    @Schema("Name of the topic", "My topic")
    val name: String,
    @Schema("Id of the folder the topic is in", "123abc")
    val folderId: String?,
    @Schema("Id of the profile the topic is in", "123abc")
    val profileId: String?,
    @Schema("Number of cards in the topic", "42")
    val cardsCount: Long,
    @Schema("Whether the topic is uploaded", "true")
    val uploaded: Boolean,
) : IModel<String, CreateTopicPayload, UpdateTopicPayload>
