package app.latexcards.models.auth

import app.latexcards.models.users.User
import dev.kaccelero.annotations.StringPropertyValidator
import kotlinx.serialization.Serializable

@Serializable
data class RegisterPayload(
    @StringPropertyValidator(maxLength = 40)
    val name: String,
    @StringPropertyValidator(regex = User.EMAIL_REGEX, maxLength = 25)
    val email: String,
    val password: String,
)
