package app.latexcards.repositories.auth

import app.latexcards.client.ILaTeXCardsClient
import app.latexcards.models.auth.AuthRequest
import app.latexcards.models.auth.AuthToken
import app.latexcards.models.auth.RefreshTokenPayload
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIUnitRemoteRepository
import io.ktor.client.call.body
import io.ktor.client.request.setBody
import io.ktor.http.*
import io.ktor.http.contentType

open class AuthAPIRemoteRepository(
    client: ILaTeXCardsClient,
) : APIUnitRemoteRepository(
    client,
    route = "auth",
    prefix = "/api/v1"
), IAuthAPIRemoteRepository {

    override suspend fun token(payload: AuthRequest): AuthToken? = client.request(
        HttpMethod.Companion.Post,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/token"
    ) {
        contentType(ContentType.Application.Json)
        setBody(payload)
    }.body()

    override suspend fun refresh(payload: RefreshTokenPayload): AuthToken? = client.request(
        HttpMethod.Companion.Post,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/refresh"
    ) {
        contentType(ContentType.Application.Json)
        setBody(payload)
    }.body()

}
