package app.latexcards.models.topics

import dev.kaccelero.annotations.ModelProperty
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class Topic(
    @ModelProperty("id")
    @Schema("Id of the topic", "123abc")
    override val id: UUID,
    @ModelProperty("string")
    @Schema("Name of the topic", "My topic")
    val name: String,
    @Schema("Id of the folder the topic is in", "123abc")
    val folderId: UUID?,
    @Schema("Id of the profile the topic is in", "123abc")
    val profileId: UUID?,
    @Schema("Number of cards in the topic", "42")
    val cardsCount: Long,
    @Schema("Whether the topic is uploaded", "true")
    val uploaded: Boolean,
) : IModel<UUID, CreateTopicPayload, UpdateTopicPayload>
