package app.latexcards.client

import app.latexcards.models.application.LaTeXCardsEnvironment
import app.latexcards.models.application.LaTeXCardsJson
import app.latexcards.repositories.profiles.ProfilesRemoteRepository
import app.latexcards.repositories.topics.TopicsRemoteRepository
import dev.kaccelero.client.AbstractAPIClient
import dev.kaccelero.commons.auth.IGetTokenUseCase
import dev.kaccelero.commons.auth.ILogoutUseCase
import dev.kaccelero.commons.auth.IRenewTokenUseCase

class LaTeXCardsClient(
    getTokenUseCase: IGetTokenUseCase,
    renewTokenUseCase: IRenewTokenUseCase,
    logoutUseCase: ILogoutUseCase,
    environment: LaTeXCardsEnvironment = LaTeXCardsEnvironment.PRODUCTION,
) : AbstractAPIClient(
    environment.baseUrl,
    getTokenUseCase,
    renewTokenUseCase,
    logoutUseCase,
    LaTeXCardsJson.json
), ILaTeXCardsClient {

    override val topics = TopicsRemoteRepository(this)
    override val profiles = ProfilesRemoteRepository(this)

}
