package app.latexcards.models.profiles

import dev.kaccelero.annotations.PayloadProperty
import dev.kaccelero.annotations.Schema
import kotlinx.serialization.Serializable

@Serializable
data class CreateProfilePayload(
    @PayloadProperty("string")
    @Schema("Username of the profile", "Nathan Fallet")
    val username: String,
    @PayloadProperty("string")
    @Schema("Biography of the profile", "Hello, I'm Nathan Fallet, a software engineer.")
    val biography: String,
    @PayloadProperty("string")
    @Schema("Image of the profile", "https://example.com/image.jpg")
    val image: String?,
)
