package app.latexcards.repositories.profiles

import app.latexcards.client.ILaTeXCardsClient
import app.latexcards.models.auth.AuthToken
import app.latexcards.models.folders.ProfileFolder
import app.latexcards.models.folders.UpdateProfileFoldersPayload
import app.latexcards.models.profiles.*
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIModelRemoteRepository
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.util.reflect.*

class ProfilesRemoteRepository(
    client: ILaTeXCardsClient,
) : APIModelRemoteRepository<Profile, String, CreateProfilePayload, UpdateProfilePayload>(
    typeInfo<Profile>(),
    typeInfo<CreateProfilePayload>(),
    typeInfo<UpdateProfilePayload>(),
    typeInfo<List<Profile>>(),
    client,
    prefix = "/api/v1"
), IProfilesRemoteRepository {

    override suspend fun get(id: String): Profile? = get(id, null)

    override suspend fun create(payload: CreateProfilePayload): Profile? = create(payload, null)

    override suspend fun token(payload: CreateProfileTokenPayload): AuthToken? = client.request(
        HttpMethod.Post,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/token"
    ) {
        contentType(ContentType.Application.Json)
        setBody(payload)
    }.body()

    override suspend fun refresh(payload: RefreshProfileTokenPayload): AuthToken? = client.request(
        HttpMethod.Post,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/refresh"
    ) {
        contentType(ContentType.Application.Json)
        setBody(payload)
    }.body()

    override suspend fun update(id: String, payload: UpdateProfilePayload): Profile? =
        update(id, payload, null)

    override suspend fun listFolders(id: String): List<ProfileFolder> = client.request(
        HttpMethod.Get,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/folders"
    ).body()

    override suspend fun updateFolders(id: String, payload: UpdateProfileFoldersPayload) = client.request(
        HttpMethod.Post,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/folders"
    ) {
        contentType(ContentType.Application.Json)
        setBody(payload)
    }.let {}

}
