package app.latexcards.repositories.topics

import app.latexcards.client.ILaTeXCardsClient
import app.latexcards.models.topics.*
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIModelRemoteRepository
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.util.reflect.*

class TopicsRemoteRepository(
    client: ILaTeXCardsClient,
) : APIModelRemoteRepository<Topic, String, CreateTopicPayload, UpdateTopicPayload>(
    typeInfo<Topic>(),
    typeInfo<CreateTopicPayload>(),
    typeInfo<UpdateTopicPayload>(),
    typeInfo<List<Topic>>(),
    client,
    prefix = "/api/v1"
), ITopicsRemoteRepository {

    override suspend fun export(id: String): TopicWithCards? = client
        .request(HttpMethod.Get, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/export")
        .body()

    override suspend fun import(payload: CreateTopicWithCardsPayload): TopicWithCards? = client
        .request(HttpMethod.Post, "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/import") {
            contentType(ContentType.Application.Json)
            setBody(payload)
        }.body()

}
