package app.latexcards.repositories.profiles

import app.latexcards.models.auth.AuthToken
import app.latexcards.models.folders.ProfileFolder
import app.latexcards.models.folders.UpdateProfileFoldersPayload
import app.latexcards.models.profiles.*
import dev.kaccelero.models.UUID

interface IProfilesRemoteRepository {

    suspend fun get(id: UUID): Profile?
    suspend fun create(payload: CreateProfilePayload): Profile?
    suspend fun token(payload: CreateProfileTokenPayload): AuthToken?
    suspend fun refresh(payload: RefreshProfileTokenPayload): AuthToken?
    suspend fun update(id: UUID, payload: UpdateProfilePayload): Profile?
    suspend fun listFolders(id: UUID): List<ProfileFolder>
    suspend fun updateFolders(id: UUID, payload: UpdateProfileFoldersPayload)

}
