package app.latexcards.models.topics

import dev.kaccelero.annotations.PayloadProperty
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class CreateTopicPayload(
    @PayloadProperty("string")
    @Schema("Name of the topic", "My topic")
    val name: String,
    @Schema("Id of the folder the topic is in", "123abc")
    val folderId: UUID? = null,
    @Schema("Whether the topic is public (for profile and community listing)", "true")
    val public: Boolean = true,
)
