package app.latexcards.repositories.users

import app.latexcards.client.ILaTeXCardsClient
import app.latexcards.models.folders.UpdateUserFoldersPayload
import app.latexcards.models.folders.UserFolder
import app.latexcards.models.users.CreateUserPayload
import app.latexcards.models.users.UpdateUserPayload
import app.latexcards.models.users.User
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.models.UnitModel
import dev.kaccelero.repositories.APIModelRemoteRepository
import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.http.*
import io.ktor.util.reflect.*

class UsersRemoteRepository(
    client: ILaTeXCardsClient,
) : APIModelRemoteRepository<User, UUID, CreateUserPayload, UpdateUserPayload>(
    typeInfo<User>(),
    typeInfo<CreateUserPayload>(),
    typeInfo<UpdateUserPayload>(),
    typeInfo<List<User>>(),
    client,
    prefix = "/api/v1"
), IUsersRemoteRepository {

    override suspend fun get(id: UUID): User? = get(id, null)

    override suspend fun update(id: UUID, payload: UpdateUserPayload): User? =
        update(id, payload, null)

    override suspend fun listFolders(id: UUID): List<UserFolder> = client.request(
        HttpMethod.Get,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/folders"
    ).body()

    override suspend fun updateFolders(id: UUID, payload: UpdateUserFoldersPayload) = client.request(
        HttpMethod.Post,
        "${constructFullRoute(RecursiveId<UnitModel, Unit, Unit>(Unit))}/$id/folders"
    ) {
        contentType(ContentType.Application.Json)
        setBody(payload)
    }.let {}

}
