package app.latexcards.models.cards

import dev.kaccelero.annotations.PayloadProperty
import dev.kaccelero.annotations.Schema
import kotlinx.serialization.Serializable

@Serializable
data class UpdateCardPayload(
    @PayloadProperty("string")
    @Schema("Name of the card", "My card")
    val name: String,
    @PayloadProperty("string")
    @Schema("Front text of the card", "Hello")
    val frontText: String? = null,
    @PayloadProperty("string")
    @Schema("Back text of the card", "World")
    val backText: String,
)
