package app.latexcards.models.topics

import app.latexcards.models.cards.CreateCardPayload
import dev.kaccelero.annotations.Schema
import kotlinx.serialization.Serializable

@Serializable
data class CreateTopicWithCardsPayload(
    @Schema("Topic to create", "{...}")
    val topic: CreateTopicPayload,
    @Schema("List of cards to add to the topic", "[{...}, {...}, {...}]")
    val cards: List<CreateCardPayload>,
    @Schema("Id of the session for the editor", "123abc")
    val editorSessionId: String? = null,
)
