package app.lexilabs.basic.ads

import androidx.compose.runtime.Composable

/**
 * Loads and displays a Banner Ad using a [Composable].
 * @param adUnitId Your AdMob AdUnitId [String]
 * @param adSize Your AdMob [AdSize]
 * @see AdUnitId.autoSelect
 */
@DependsOnGoogleMobileAds
@Composable public expect fun BannerAd(
    adUnitId: String = AdUnitId.BANNER_DEFAULT,
    adSize: AdSize = AdSize.FULL_BANNER
)

/**
 * Loads and displays an Interstitial Ad using a [Composable].
 * @param adUnitId Your AdMob AdUnitId [String]
 * @param onDismissed Lambda that executes when the user closes the ad
 * @see AdUnitId.autoSelect
 */
@DependsOnGoogleMobileAds
@Composable public expect fun InterstitialAd(
    activity: Any? = null,
    adUnitId: String = AdUnitId.INTERSTITIAL_DEFAULT,
    onDismissed: () -> Unit = {}
)

/**
 * Loads and displays a Rewarded Ad using a [Composable].
 * @param adUnitId Your AdMob AdUnitId [String]
 * @param onDismissed Lambda that executes when the user closes the ad
 * @param onRewardEarned Lambda that executes when the user has earned an ad-related reward
 * @see AdUnitId.autoSelect
 */
@DependsOnGoogleMobileAds
@Composable public expect fun RewardedAd(
    activity: Any? = null,
    adUnitId: String = AdUnitId.REWARDED_DEFAULT,
    onDismissed: () -> Unit = {},
    onRewardEarned: () -> Unit = {}
)

/**
 * Loads and displays a Rewarded Interstitial Ad using a [Composable].
 * @param adUnitId Your AdMob AdUnitId [String]
 * @param onDismissed Lambda that executes when the user closes the ad
 * @param onRewardEarned Lambda that executes when the user has earned an ad-related reward
 * @see AdUnitId.autoSelect
 */
@DependsOnGoogleMobileAds
@Composable public expect fun RewardedInterstitialAd(
    activity: Any? = null,
    adUnitId: String = AdUnitId.REWARDED_INTERSTITIAL_DEFAULT,
    onDismissed: () -> Unit = {},
    onRewardEarned: () -> Unit = {}
)