/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.image;

import app.moviebase.tmdb.image.TmdbImage;
import app.moviebase.tmdb.image.TmdbImageSize;
import app.moviebase.tmdb.image.YoutubeImageSize;
import app.moviebase.tmdb.model.TmdbVideo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lapp/moviebase/tmdb/image/TmdbImageUrlBuilder;", "", "()V", "build", "", "image", "Lapp/moviebase/tmdb/image/TmdbImage;", "width", "", "height", "sizeKey", "imagePath", "buildYoutube", "video", "Lapp/moviebase/tmdb/model/TmdbVideo;", "youtubeKey", "imageFileSize", "tmdb-api"})
public final class TmdbImageUrlBuilder {
    @NotNull
    public static final TmdbImageUrlBuilder INSTANCE;

    @NotNull
    public final String build(@NotNull String sizeKey, @NotNull String imagePath) {
        Intrinsics.checkNotNullParameter((Object)sizeKey, (String)"sizeKey");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        String url = "http://image.tmdb.org/t/p/" + sizeKey;
        if (!StringsKt.startsWith$default((String)imagePath, (String)"/", (boolean)false, (int)2, null)) {
            url = url + "/";
        }
        return url + imagePath;
    }

    @NotNull
    public final String build(@NotNull TmdbImage image, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String sizeKey = TmdbImageSize.INSTANCE.getSizeKey(image.getType(), width, height);
        return this.build(sizeKey, image.getPath());
    }

    @NotNull
    public final String buildYoutube(@NotNull String youtubeKey, @NotNull String imageFileSize) {
        Intrinsics.checkNotNullParameter((Object)youtubeKey, (String)"youtubeKey");
        Intrinsics.checkNotNullParameter((Object)imageFileSize, (String)"imageFileSize");
        return "http://img.youtube.com/vi/" + youtubeKey + "/" + imageFileSize + ".jpg";
    }

    @NotNull
    public final String buildYoutube(@NotNull TmdbVideo video, int width) {
        Intrinsics.checkNotNullParameter((Object)video, (String)"video");
        String imageFileSize = YoutubeImageSize.INSTANCE.getYoutubeSizeKey(width);
        return this.buildYoutube(video.getKey(), imageFileSize);
    }

    private TmdbImageUrlBuilder() {
    }

    static {
        TmdbImageUrlBuilder tmdbImageUrlBuilder;
        INSTANCE = tmdbImageUrlBuilder = new TmdbImageUrlBuilder();
    }
}

