/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.image;

import app.moviebase.tmdb.image.TmdbImage;
import app.moviebase.tmdb.image.TmdbImageSize;
import app.moviebase.tmdb.image.TmdbImageType;
import app.moviebase.tmdb.image.YoutubeImageSize;
import app.moviebase.tmdb.model.TmdbBackdropMedia;
import app.moviebase.tmdb.model.TmdbPosterMedia;
import app.moviebase.tmdb.model.TmdbVideo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u00a8\u0006\u0017"}, d2={"Lapp/moviebase/tmdb/image/TmdbImageUrlBuilder;", "", "()V", "build", "", "image", "Lapp/moviebase/tmdb/image/TmdbImage;", "width", "", "height", "imagePath", "type", "Lapp/moviebase/tmdb/image/TmdbImageType;", "sizeKey", "buildBackdrop", "Lapp/moviebase/tmdb/model/TmdbBackdropMedia;", "buildPoster", "Lapp/moviebase/tmdb/model/TmdbPosterMedia;", "buildYoutube", "video", "Lapp/moviebase/tmdb/model/TmdbVideo;", "youtubeKey", "imageFileSize", "tmdb-api"})
public final class TmdbImageUrlBuilder {
    @NotNull
    public static final TmdbImageUrlBuilder INSTANCE = new TmdbImageUrlBuilder();

    private TmdbImageUrlBuilder() {
    }

    @NotNull
    public final String build(@NotNull String imagePath, @NotNull String sizeKey) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        Intrinsics.checkNotNullParameter((Object)sizeKey, (String)"sizeKey");
        String url = Intrinsics.stringPlus((String)"https://image.tmdb.org/t/p/", (Object)sizeKey);
        if (!StringsKt.startsWith$default((String)imagePath, (String)"/", (boolean)false, (int)2, null)) {
            url = Intrinsics.stringPlus((String)url, (Object)"/");
        }
        return Intrinsics.stringPlus((String)url, (Object)imagePath);
    }

    @NotNull
    public final String build(@NotNull String imagePath, @NotNull TmdbImageType type, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String sizeKey = TmdbImageSize.INSTANCE.getSizeKey(type, width, height);
        return this.build(imagePath, sizeKey);
    }

    @NotNull
    public final String build(@NotNull TmdbImage image, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.build(image.getPath(), image.getType(), width, height);
    }

    @Nullable
    public final String buildPoster(@NotNull TmdbPosterMedia image, int width) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String string = image.getPosterPath();
        if (string == null) {
            return null;
        }
        String posterPath = string;
        String sizeKey = TmdbImageSize.INSTANCE.getPosterSizeKey(width);
        return this.build(posterPath, sizeKey);
    }

    @Nullable
    public final String buildBackdrop(@NotNull TmdbBackdropMedia image, int width) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String string = image.getBackdropPath();
        if (string == null) {
            return null;
        }
        String posterPath = string;
        String sizeKey = TmdbImageSize.INSTANCE.getBackdropSizeKey(width);
        return this.build(posterPath, sizeKey);
    }

    @NotNull
    public final String buildYoutube(@NotNull String youtubeKey, @NotNull String imageFileSize) {
        Intrinsics.checkNotNullParameter((Object)youtubeKey, (String)"youtubeKey");
        Intrinsics.checkNotNullParameter((Object)imageFileSize, (String)"imageFileSize");
        return "https://img.youtube.com/vi/" + youtubeKey + '/' + imageFileSize + ".jpg";
    }

    @Nullable
    public final String buildYoutube(@NotNull TmdbVideo video, int width) {
        Intrinsics.checkNotNullParameter((Object)video, (String)"video");
        String imageFileSize = YoutubeImageSize.INSTANCE.getYoutubeSizeKey(width);
        String string = video.getKey();
        if (string == null) {
            return null;
        }
        String key = string;
        return this.buildYoutube(key, imageFileSize);
    }
}

