/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.image;

import app.moviebase.tmdb.image.TmdbImageType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010!\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dJ\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010$\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dJ\u001e\u0010%\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lapp/moviebase/tmdb/image/TmdbImageSize;", "", "()V", "BACKDROP_W1280", "", "BACKDROP_W185", "BACKDROP_W300", "BACKDROP_W500", "BACKDROP_W780", "LOGO_H100", "LOGO_H60", "LOGO_W154", "LOGO_W185", "LOGO_W300", "LOGO_W45", "LOGO_W500", "LOGO_W92", "ORIGINAL", "POSTER_W154", "POSTER_W185", "POSTER_W342", "POSTER_W500", "POSTER_W780", "POSTER_W92", "PROFILE_H632", "PROFILE_W185", "PROFILE_W45", "getBackdropSizeKey", "width", "", "getLargestSizeKey", "type", "Lapp/moviebase/tmdb/image/TmdbImageType;", "getLogoSizeKey", "height", "getPosterSizeKey", "getProfileSizeKey", "getSizeKey", "tmdb-api"})
public final class TmdbImageSize {
    @NotNull
    public static final TmdbImageSize INSTANCE = new TmdbImageSize();
    @NotNull
    public static final String ORIGINAL = "original";
    @NotNull
    public static final String LOGO_W45 = "w45";
    @NotNull
    public static final String LOGO_W92 = "w92";
    @NotNull
    public static final String LOGO_W154 = "w154";
    @NotNull
    public static final String LOGO_W185 = "w185";
    @NotNull
    public static final String LOGO_W300 = "w300";
    @NotNull
    public static final String LOGO_W500 = "w500";
    @NotNull
    public static final String LOGO_H60 = "h60";
    @NotNull
    public static final String LOGO_H100 = "h100";
    @NotNull
    public static final String PROFILE_W45 = "w45";
    @NotNull
    public static final String PROFILE_W185 = "w185";
    @NotNull
    public static final String PROFILE_H632 = "h632";
    @NotNull
    public static final String POSTER_W92 = "w92";
    @NotNull
    public static final String POSTER_W154 = "w154";
    @NotNull
    public static final String POSTER_W185 = "w185";
    @NotNull
    public static final String POSTER_W342 = "w342";
    @NotNull
    public static final String POSTER_W500 = "w500";
    @NotNull
    public static final String POSTER_W780 = "w780";
    @NotNull
    public static final String BACKDROP_W185 = "w185";
    @NotNull
    public static final String BACKDROP_W300 = "w300";
    @NotNull
    public static final String BACKDROP_W500 = "w500";
    @NotNull
    public static final String BACKDROP_W780 = "w780";
    @NotNull
    public static final String BACKDROP_W1280 = "w1280";

    private TmdbImageSize() {
    }

    @NotNull
    public final String getSizeKey(@NotNull TmdbImageType type, int width, int height) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                string = this.getPosterSizeKey(width);
                break;
            }
            case 2: {
                string = this.getBackdropSizeKey(width);
                break;
            }
            case 3: {
                string = this.getProfileSizeKey(width, height);
                break;
            }
            case 4: {
                string = this.getLogoSizeKey(width, height);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String getLargestSizeKey(@NotNull TmdbImageType type, int width) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                string = this.getPosterSizeKey(width < 500 ? 500 : 780);
                break;
            }
            case 2: {
                string = this.getBackdropSizeKey(width < 780 ? 780 : 1280);
                break;
            }
            case 3: {
                string = this.getProfileSizeKey(200, 632);
                break;
            }
            case 4: {
                string = this.getLogoSizeKey(width < 300 ? 300 : 500, 500);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String getLogoSizeKey(int width, int height) {
        return width <= 45 ? "w45" : (height <= 60 ? LOGO_H60 : (height <= 100 ? LOGO_H100 : (width <= 154 ? "w154" : (width <= 185 ? "w185" : (width <= 300 ? "w300" : (width <= 500 ? "w500" : ORIGINAL))))));
    }

    @NotNull
    public final String getPosterSizeKey(int width) {
        return width <= 92 ? "w92" : (width <= 154 ? "w154" : (width <= 185 ? "w185" : (width <= 342 ? POSTER_W342 : (width <= 500 ? "w500" : (width <= 780 ? "w780" : ORIGINAL)))));
    }

    @NotNull
    public final String getProfileSizeKey(int width, int height) {
        return width <= 45 ? "w45" : (width <= 185 ? "w185" : (height <= 632 ? PROFILE_H632 : ORIGINAL));
    }

    @NotNull
    public final String getBackdropSizeKey(int width) {
        return width <= 185 ? "w185" : (width <= 300 ? "w300" : (width <= 500 ? "w500" : (width <= 780 ? "w780" : (width <= 1280 ? BACKDROP_W1280 : ORIGINAL))));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TmdbImageType.values().length];
            try {
                nArray[TmdbImageType.POSTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbImageType.BACKDROP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbImageType.PROFILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbImageType.LOGO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

