/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.url;

import app.moviebase.tmdb.model.TmdbVideo;
import app.moviebase.tmdb.model.TmdbVideoSite;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lapp/moviebase/tmdb/url/TmdbUrlBuilder;", "", "()V", "buildReviewPage", "", "reviewId", "", "buildUserPage", "userId", "buildVideo", "tmdbVideo", "Lapp/moviebase/tmdb/model/TmdbVideo;", "tmdb-api"})
public final class TmdbUrlBuilder {
    @NotNull
    public static final TmdbUrlBuilder INSTANCE = new TmdbUrlBuilder();

    private TmdbUrlBuilder() {
    }

    @NotNull
    public final String buildUserPage(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return "https://www.themoviedb.org/u/" + userId;
    }

    @NotNull
    public final String buildReviewPage(int reviewId) {
        return "https://www.themoviedb.org/review/" + reviewId;
    }

    @Nullable
    public final String buildVideo(@NotNull TmdbVideo tmdbVideo) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tmdbVideo, (String)"tmdbVideo");
        TmdbVideoSite tmdbVideoSite = tmdbVideo.getSite();
        switch (tmdbVideoSite == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tmdbVideoSite.ordinal()]) {
            case 1: {
                string = "https://www.youtube.com/watch?v=" + tmdbVideo.getKey();
                break;
            }
            case 2: {
                string = "https://vimeo.com/" + tmdbVideo.getKey();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TmdbVideoSite.values().length];
            try {
                nArray[TmdbVideoSite.YOUTUBE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbVideoSite.VIMEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

