/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.discover;

import app.moviebase.tmdb.core.DateTimeExtensionsKt;
import app.moviebase.tmdb.discover.DiscoverCategory;
import app.moviebase.tmdb.model.TmdbDiscover;
import app.moviebase.tmdb.model.TmdbDiscoverFilter;
import app.moviebase.tmdb.model.TmdbDiscoverMovieSortBy;
import app.moviebase.tmdb.model.TmdbDiscoverShowSortBy;
import app.moviebase.tmdb.model.TmdbDiscoverTimeRange;
import app.moviebase.tmdb.model.TmdbMediaType;
import app.moviebase.tmdb.model.TmdbReleaseType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u001c"}, d2={"Lapp/moviebase/tmdb/discover/DiscoverFactory;", "", "<init>", "()V", "createByCategory", "Lapp/moviebase/tmdb/model/TmdbDiscover;", "category", "Lapp/moviebase/tmdb/discover/DiscoverCategory;", "createNowPlaying", "Lapp/moviebase/tmdb/model/TmdbDiscover$Movie;", "createAiringToday", "Lapp/moviebase/tmdb/model/TmdbDiscover$Show;", "createOnTv", "createOnDvd", "createUpcoming", "createPopular", "mediaType", "Lapp/moviebase/tmdb/model/TmdbMediaType;", "createTopRated", "createNetwork", "network", "", "createOnStreaming", "watchProviders", "Lapp/moviebase/tmdb/model/TmdbDiscoverFilter;", "watchRegion", "", "createForOneYear", "tmdb-api"})
public final class DiscoverFactory {
    @NotNull
    public static final DiscoverFactory INSTANCE = new DiscoverFactory();

    private DiscoverFactory() {
    }

    @NotNull
    public final TmdbDiscover createByCategory(@NotNull DiscoverCategory category) {
        TmdbDiscover tmdbDiscover;
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        DiscoverCategory discoverCategory = category;
        if (Intrinsics.areEqual((Object)discoverCategory, (Object)DiscoverCategory.NowPlaying.INSTANCE)) {
            tmdbDiscover = this.createNowPlaying();
        } else if (Intrinsics.areEqual((Object)discoverCategory, (Object)DiscoverCategory.Upcoming.INSTANCE)) {
            tmdbDiscover = this.createUpcoming();
        } else if (discoverCategory instanceof DiscoverCategory.Popular) {
            tmdbDiscover = this.createPopular(((DiscoverCategory.Popular)category).getMediaType());
        } else if (discoverCategory instanceof DiscoverCategory.TopRated) {
            tmdbDiscover = this.createTopRated(((DiscoverCategory.TopRated)category).getMediaType());
        } else if (Intrinsics.areEqual((Object)discoverCategory, (Object)DiscoverCategory.AiringToday.INSTANCE)) {
            tmdbDiscover = this.createAiringToday();
        } else if (Intrinsics.areEqual((Object)discoverCategory, (Object)DiscoverCategory.OnTv.INSTANCE)) {
            tmdbDiscover = this.createOnTv();
        } else if (discoverCategory instanceof DiscoverCategory.OnDvd) {
            tmdbDiscover = this.createOnDvd();
        } else if (discoverCategory instanceof DiscoverCategory.Network) {
            tmdbDiscover = this.createNetwork(((DiscoverCategory.Network)category).getNetwork());
        } else if (discoverCategory instanceof DiscoverCategory.OnStreaming) {
            tmdbDiscover = this.createOnStreaming(((DiscoverCategory.OnStreaming)category).getMediaType(), ((DiscoverCategory.OnStreaming)category).getWatchProviders(), ((DiscoverCategory.OnStreaming)category).getWatchRegion());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return tmdbDiscover;
    }

    @NotNull
    public final TmdbDiscover.Movie createNowPlaying() {
        LocalDate localDate = DateTimeExtensionsKt.currentLocalDate$default(null, 1, null);
        LocalDate firstDate = DateTimeExtensionsKt.minusWeeks(localDate, 6);
        LocalDate lastDate = DateTimeExtensionsKt.plusDays(localDate, 1);
        TmdbDiscoverTimeRange.Custom discoverTimeRange = new TmdbDiscoverTimeRange.Custom(firstDate.toString(), lastDate.toString());
        return new TmdbDiscover.Movie(null, null, null, null, null, null, null, null, null, discoverTimeRange, new TmdbDiscoverFilter(null, SetsKt.setOf((Object)((Object)TmdbReleaseType.THEATRICAL)), 1, null), null, null, null, 14847, null);
    }

    @NotNull
    public final TmdbDiscover.Show createAiringToday() {
        String localDate = DateTimeExtensionsKt.currentLocalDate$default(null, 1, null).toString();
        return new TmdbDiscover.Show(null, null, null, null, null, null, null, null, null, localDate, localDate, null, null, null, null, null, 63999, null);
    }

    @NotNull
    public final TmdbDiscover.Show createOnTv() {
        LocalDate airDateGte = DateTimeExtensionsKt.currentLocalDate$default(null, 1, null);
        LocalDate airDateLte = DateTimeExtensionsKt.plusWeeks(airDateGte, 2);
        return new TmdbDiscover.Show(null, null, null, null, null, null, null, null, null, airDateGte.toString(), airDateLte.toString(), null, null, null, null, null, 63999, null);
    }

    @NotNull
    public final TmdbDiscover createOnDvd() {
        return new TmdbDiscover.Movie(null, TmdbDiscoverMovieSortBy.RELEASE_DATE, null, null, null, null, null, null, null, null, new TmdbDiscoverFilter(null, SetsKt.setOf((Object)((Object)TmdbReleaseType.PHYSICAL)), 1, null), null, null, null, 15357, null);
    }

    @NotNull
    public final TmdbDiscover createUpcoming() {
        LocalDate localDate = DateTimeExtensionsKt.currentLocalDate$default(null, 1, null);
        LocalDate firstDate = DateTimeExtensionsKt.plusDays(localDate, 2);
        LocalDate lastDate = DateTimeExtensionsKt.plusWeeks(localDate, 3);
        TmdbDiscoverTimeRange.Custom discoverTimeRange = new TmdbDiscoverTimeRange.Custom(firstDate.toString(), lastDate.toString());
        return new TmdbDiscover.Movie(null, null, null, null, null, null, null, null, null, discoverTimeRange, null, null, null, null, 15871, null);
    }

    @NotNull
    public final TmdbDiscover createPopular(@NotNull TmdbMediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        return switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1 -> new TmdbDiscover.Movie(null, TmdbDiscoverMovieSortBy.POPULARITY, null, null, null, null, null, null, null, null, null, null, null, null, 16381, null);
            case 2 -> new TmdbDiscover.Show(TmdbDiscoverShowSortBy.POPULARITY, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 65534, null);
            default -> throw new IllegalArgumentException(mediaType + " type is not supported for discover");
        };
    }

    @NotNull
    public final TmdbDiscover createTopRated(@NotNull TmdbMediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        return switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1 -> new TmdbDiscover.Movie(null, TmdbDiscoverMovieSortBy.VOTE_AVERAGE, null, null, null, 200, null, null, null, null, null, null, null, null, 16349, null);
            case 2 -> new TmdbDiscover.Show(TmdbDiscoverShowSortBy.VOTE_AVERAGE, null, null, null, 200, null, null, null, null, null, null, null, null, null, null, null, 65518, null);
            default -> throw new IllegalArgumentException(mediaType + " type is not supported for discover");
        };
    }

    @NotNull
    public final TmdbDiscover.Show createNetwork(int network) {
        TmdbDiscoverFilter tmdbDiscoverFilter = new TmdbDiscoverFilter(null, SetsKt.setOf((Object)network), 1, null);
        TmdbDiscoverShowSortBy tmdbDiscoverShowSortBy = TmdbDiscoverShowSortBy.POPULARITY;
        return new TmdbDiscover.Show(tmdbDiscoverShowSortBy, null, null, null, null, null, null, null, null, null, null, tmdbDiscoverFilter, null, null, null, null, 63486, null);
    }

    @NotNull
    public final TmdbDiscover createOnStreaming(@NotNull TmdbMediaType mediaType, @NotNull TmdbDiscoverFilter<Integer> watchProviders, @NotNull String watchRegion) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter(watchProviders, (String)"watchProviders");
        Intrinsics.checkNotNullParameter((Object)watchRegion, (String)"watchRegion");
        return switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1 -> new TmdbDiscover.Movie(null, TmdbDiscoverMovieSortBy.POPULARITY, null, null, null, null, null, null, null, null, null, watchProviders, watchRegion, null, 10237, null);
            case 2 -> new TmdbDiscover.Show(TmdbDiscoverShowSortBy.POPULARITY, null, null, null, null, null, null, null, null, null, null, null, null, watchProviders, watchRegion, null, 40958, null);
            default -> throw new IllegalArgumentException(mediaType + " type is not supported for discover");
        };
    }

    @NotNull
    public final TmdbDiscover createForOneYear(@NotNull TmdbMediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        TmdbDiscoverTimeRange.OneYear discoverTimeRange = new TmdbDiscoverTimeRange.OneYear(DateTimeExtensionsKt.currentLocalDate$default(null, 1, null).getYear());
        return switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1 -> new TmdbDiscover.Movie(null, null, null, null, null, null, null, null, null, discoverTimeRange, null, null, null, null, 15871, null);
            case 2 -> new TmdbDiscover.Show(null, null, null, null, null, null, null, null, discoverTimeRange, null, null, null, null, null, null, null, 65279, null);
            default -> throw new IllegalArgumentException(mediaType + " type is not supported for discover");
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TmdbMediaType.values().length];
            try {
                nArray[TmdbMediaType.MOVIE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbMediaType.SHOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

