/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.url;

import app.moviebase.tmdb.model.TmdbMediaType;
import app.moviebase.tmdb.model.TmdbVideo;
import app.moviebase.tmdb.model.TmdbVideoSite;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lapp/moviebase/tmdb/url/TmdbUrlBuilder;", "", "<init>", "()V", "buildUserPage", "", "userId", "buildReviewPage", "reviewId", "", "buildWatch", "mediaType", "Lapp/moviebase/tmdb/model/TmdbMediaType;", "mediaId", "region", "buildVideo", "tmdbVideo", "Lapp/moviebase/tmdb/model/TmdbVideo;", "tmdb-api"})
@SourceDebugExtension(value={"SMAP\nTmdbUrlBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TmdbUrlBuilder.kt\napp/moviebase/tmdb/url/TmdbUrlBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class TmdbUrlBuilder {
    @NotNull
    public static final TmdbUrlBuilder INSTANCE = new TmdbUrlBuilder();

    private TmdbUrlBuilder() {
    }

    @NotNull
    public final String buildUserPage(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return "https://www.themoviedb.org/u/" + userId;
    }

    @NotNull
    public final String buildReviewPage(int reviewId) {
        return "https://www.themoviedb.org/review/" + reviewId;
    }

    @NotNull
    public final String buildWatch(@NotNull TmdbMediaType mediaType, int mediaId, @NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        if (!(mediaType == TmdbMediaType.MOVIE || mediaType == TmdbMediaType.SHOW)) {
            boolean bl = false;
            String string = "Only movie and tv are supported";
            throw new IllegalArgumentException(string.toString());
        }
        String tmdbMediaType = mediaType == TmdbMediaType.MOVIE ? "movie" : "tv";
        return "https://www.themoviedb.org/" + tmdbMediaType + "/" + mediaId + "/watch?locale=" + region;
    }

    @Nullable
    public final String buildVideo(@NotNull TmdbVideo tmdbVideo) {
        Intrinsics.checkNotNullParameter((Object)tmdbVideo, (String)"tmdbVideo");
        TmdbVideoSite tmdbVideoSite = tmdbVideo.getSite();
        return switch (tmdbVideoSite == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tmdbVideoSite.ordinal()]) {
            case 1 -> "https://www.youtube.com/watch?v=" + tmdbVideo.getKey();
            case 2 -> "https://vimeo.com/" + tmdbVideo.getKey();
            default -> null;
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TmdbVideoSite.values().length];
            try {
                nArray[TmdbVideoSite.YOUTUBE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbVideoSite.VIMEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

