/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.image;

import app.moviebase.tmdb.image.TmdbImage;
import app.moviebase.tmdb.image.TmdbImageSize;
import app.moviebase.tmdb.image.TmdbImageType;
import app.moviebase.tmdb.image.YoutubeImageSize;
import app.moviebase.tmdb.model.TmdbBackdropItem;
import app.moviebase.tmdb.model.TmdbPosterItem;
import app.moviebase.tmdb.model.TmdbVideo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0005J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0016\u001a\u00020\u0005\u00a8\u0006\u001b"}, d2={"Lapp/moviebase/tmdb/image/TmdbImageUrlBuilder;", "", "<init>", "()V", "build", "", "imagePath", "sizeKey", "type", "Lapp/moviebase/tmdb/image/TmdbImageType;", "width", "", "height", "image", "Lapp/moviebase/tmdb/image/TmdbImage;", "buildAlternativeUrls", "", "buildPoster", "Lapp/moviebase/tmdb/model/TmdbPosterItem;", "buildBackdrop", "Lapp/moviebase/tmdb/model/TmdbBackdropItem;", "buildYoutube", "youtubeKey", "imageFileSize", "video", "Lapp/moviebase/tmdb/model/TmdbVideo;", "buildYoutubeAlternativeUrls", "tmdb-api"})
public final class TmdbImageUrlBuilder {
    @NotNull
    public static final TmdbImageUrlBuilder INSTANCE = new TmdbImageUrlBuilder();

    private TmdbImageUrlBuilder() {
    }

    @NotNull
    public final String build(@NotNull String imagePath, @NotNull String sizeKey) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        Intrinsics.checkNotNullParameter((Object)sizeKey, (String)"sizeKey");
        String url = "https://image.tmdb.org/t/p/" + sizeKey;
        if (!StringsKt.startsWith$default((String)imagePath, (String)"/", (boolean)false, (int)2, null)) {
            url = url + "/";
        }
        return url + imagePath;
    }

    @NotNull
    public final String build(@NotNull String imagePath, @NotNull TmdbImageType type, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String sizeKey = TmdbImageSize.INSTANCE.getSizeKey(type, width, height);
        return this.build(imagePath, sizeKey);
    }

    @NotNull
    public final String build(@NotNull TmdbImage image, @NotNull String sizeKey) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)sizeKey, (String)"sizeKey");
        return this.build(image.getPath(), sizeKey);
    }

    @NotNull
    public final String build(@NotNull TmdbImage image, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.build(image.getPath(), image.getType(), width, height);
    }

    @NotNull
    public final List<String> buildAlternativeUrls(@NotNull TmdbImage image, int width) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String sizeKey = TmdbImageSize.INSTANCE.getLargestSizeKey(image.getType(), width);
        String largestUrl = this.build(image, sizeKey);
        String originalUrl = this.build(image, "original");
        Object[] objectArray = new String[]{largestUrl, originalUrl};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final String buildPoster(@NotNull TmdbPosterItem image, int width) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String string = image.getPosterPath();
        if (string == null) {
            return null;
        }
        String posterPath = string;
        String sizeKey = TmdbImageSize.INSTANCE.getPosterSizeKey(width);
        return this.build(posterPath, sizeKey);
    }

    @Nullable
    public final String buildBackdrop(@NotNull TmdbBackdropItem image, int width) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String string = image.getBackdropPath();
        if (string == null) {
            return null;
        }
        String posterPath = string;
        String sizeKey = TmdbImageSize.INSTANCE.getBackdropSizeKey(width);
        return this.build(posterPath, sizeKey);
    }

    @NotNull
    public final String buildYoutube(@NotNull String youtubeKey, @NotNull String imageFileSize) {
        Intrinsics.checkNotNullParameter((Object)youtubeKey, (String)"youtubeKey");
        Intrinsics.checkNotNullParameter((Object)imageFileSize, (String)"imageFileSize");
        return "https://img.youtube.com/vi/" + youtubeKey + "/" + imageFileSize + ".jpg";
    }

    @NotNull
    public final String buildYoutube(@NotNull String youtubeKey, int width) {
        Intrinsics.checkNotNullParameter((Object)youtubeKey, (String)"youtubeKey");
        String imageFileSize = YoutubeImageSize.INSTANCE.getYoutubeSizeKey(width);
        return this.buildYoutube(youtubeKey, imageFileSize);
    }

    @Nullable
    public final String buildYoutube(@NotNull TmdbVideo video, int width) {
        Intrinsics.checkNotNullParameter((Object)video, (String)"video");
        String string = video.getKey();
        if (string == null) {
            return null;
        }
        String key = string;
        return this.buildYoutube(key, width);
    }

    @NotNull
    public final List<String> buildYoutubeAlternativeUrls(@NotNull String youtubeKey) {
        Intrinsics.checkNotNullParameter((Object)youtubeKey, (String)"youtubeKey");
        String url = this.buildYoutube(youtubeKey, "hqdefault");
        return CollectionsKt.listOf((Object)url);
    }
}

