/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.tmdb.url;

import app.moviebase.tmdb.model.TmdbMediaType;
import app.moviebase.tmdb.model.TmdbVideo;
import app.moviebase.tmdb.model.TmdbVideoSite;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013J3\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\t2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\t\u00a8\u0006\u001b"}, d2={"Lapp/moviebase/tmdb/url/TmdbUrlBuilder;", "", "<init>", "()V", "buildUserPage", "", "userId", "buildReviewPage", "reviewId", "", "buildWatch", "mediaType", "Lapp/moviebase/tmdb/model/TmdbMediaType;", "mediaId", "region", "buildList", "listId", "buildVideo", "tmdbVideo", "Lapp/moviebase/tmdb/model/TmdbVideo;", "buildMedia", "parentId", "seasonNumber", "episodeNumber", "(Lapp/moviebase/tmdb/model/TmdbMediaType;ILjava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/String;", "buildPerson", "personId", "tmdb-api"})
@SourceDebugExtension(value={"SMAP\nTmdbUrlBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TmdbUrlBuilder.kt\napp/moviebase/tmdb/url/TmdbUrlBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class TmdbUrlBuilder {
    @NotNull
    public static final TmdbUrlBuilder INSTANCE = new TmdbUrlBuilder();

    private TmdbUrlBuilder() {
    }

    @NotNull
    public final String buildUserPage(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return "https://www.themoviedb.org/u/" + userId;
    }

    @NotNull
    public final String buildReviewPage(int reviewId) {
        return "https://www.themoviedb.org/review/" + reviewId;
    }

    @NotNull
    public final String buildWatch(@NotNull TmdbMediaType mediaType, int mediaId, @NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        if (!(mediaType == TmdbMediaType.MOVIE || mediaType == TmdbMediaType.SHOW)) {
            boolean bl = false;
            String string = "Only movie and tv are supported";
            throw new IllegalArgumentException(string.toString());
        }
        String tmdbMediaType = mediaType == TmdbMediaType.MOVIE ? "movie" : "tv";
        return "https://www.themoviedb.org/" + tmdbMediaType + "/" + mediaId + "/watch?locale=" + region;
    }

    @NotNull
    public final String buildList(int listId) {
        return "https://www.themoviedb.org/list/" + listId;
    }

    @Nullable
    public final String buildVideo(@NotNull TmdbVideo tmdbVideo) {
        Intrinsics.checkNotNullParameter((Object)tmdbVideo, (String)"tmdbVideo");
        TmdbVideoSite tmdbVideoSite = tmdbVideo.getSite();
        return switch (tmdbVideoSite == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tmdbVideoSite.ordinal()]) {
            case 1 -> "https://www.youtube.com/watch?v=" + tmdbVideo.getKey();
            case 2 -> "https://vimeo.com/" + tmdbVideo.getKey();
            default -> null;
        };
    }

    @NotNull
    public final String buildMedia(@NotNull TmdbMediaType mediaType, int parentId, @Nullable Integer seasonNumber, @Nullable Integer episodeNumber) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        return switch (WhenMappings.$EnumSwitchMapping$1[mediaType.ordinal()]) {
            case 1 -> "https://www.themoviedb.org/movie/" + parentId;
            case 2 -> "https://www.themoviedb.org/tv/" + parentId;
            case 3 -> "https://www.themoviedb.org/tv/" + parentId + "/season/" + seasonNumber;
            case 4 -> "https://www.themoviedb.org/tv/" + parentId + "/season/" + seasonNumber + "/episode/" + episodeNumber;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ String buildMedia$default(TmdbUrlBuilder tmdbUrlBuilder, TmdbMediaType tmdbMediaType, int n, Integer n2, Integer n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = null;
        }
        if ((n4 & 8) != 0) {
            n3 = null;
        }
        return tmdbUrlBuilder.buildMedia(tmdbMediaType, n, n2, n3);
    }

    @NotNull
    public final String buildPerson(int personId) {
        return "https://www.themoviedb.org/person/" + personId;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TmdbVideoSite.values().length];
            try {
                nArray[TmdbVideoSite.YOUTUBE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbVideoSite.VIMEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TmdbMediaType.values().length];
            try {
                nArray[TmdbMediaType.MOVIE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbMediaType.SHOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbMediaType.SEASON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TmdbMediaType.EPISODE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

