/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.trakt;

import app.moviebase.trakt.api.TraktCheckinApi;
import app.moviebase.trakt.api.TraktEpisodesApi;
import app.moviebase.trakt.api.TraktMoviesApi;
import app.moviebase.trakt.api.TraktSearchApi;
import app.moviebase.trakt.api.TraktSeasonsApi;
import app.moviebase.trakt.api.TraktShowsApi;
import app.moviebase.trakt.remote.TraktHttpClientFactory;
import io.ktor.client.HttpClient;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lapp/moviebase/trakt/Trakt;", "", "traktClientId", "", "(Ljava/lang/String;)V", "checkin", "Lapp/moviebase/trakt/api/TraktCheckinApi;", "getCheckin", "()Lapp/moviebase/trakt/api/TraktCheckinApi;", "client", "Lio/ktor/client/HttpClient;", "episodes", "Lapp/moviebase/trakt/api/TraktEpisodesApi;", "getEpisodes", "()Lapp/moviebase/trakt/api/TraktEpisodesApi;", "movies", "Lapp/moviebase/trakt/api/TraktMoviesApi;", "getMovies", "()Lapp/moviebase/trakt/api/TraktMoviesApi;", "search", "Lapp/moviebase/trakt/api/TraktSearchApi;", "getSearch", "()Lapp/moviebase/trakt/api/TraktSearchApi;", "seasons", "Lapp/moviebase/trakt/api/TraktSeasonsApi;", "getSeasons", "()Lapp/moviebase/trakt/api/TraktSeasonsApi;", "shows", "Lapp/moviebase/trakt/api/TraktShowsApi;", "getShows", "()Lapp/moviebase/trakt/api/TraktShowsApi;", "lib"})
public final class Trakt {
    @NotNull
    private final HttpClient client;
    @NotNull
    private final TraktMoviesApi movies;
    @NotNull
    private final TraktShowsApi shows;
    @NotNull
    private final TraktSeasonsApi seasons;
    @NotNull
    private final TraktEpisodesApi episodes;
    @NotNull
    private final TraktCheckinApi checkin;
    @NotNull
    private final TraktSearchApi search;

    public Trakt(@NotNull String traktClientId) {
        Intrinsics.checkNotNullParameter((Object)traktClientId, (String)"traktClientId");
        this.client = TraktHttpClientFactory.INSTANCE.create(traktClientId);
        this.movies = new TraktMoviesApi(this.client);
        this.shows = new TraktShowsApi(this.client);
        this.seasons = new TraktSeasonsApi(this.client);
        this.episodes = new TraktEpisodesApi(this.client);
        this.checkin = new TraktCheckinApi(this.client);
        this.search = new TraktSearchApi(this.client);
    }

    @NotNull
    public final TraktMoviesApi getMovies() {
        return this.movies;
    }

    @NotNull
    public final TraktShowsApi getShows() {
        return this.shows;
    }

    @NotNull
    public final TraktSeasonsApi getSeasons() {
        return this.seasons;
    }

    @NotNull
    public final TraktEpisodesApi getEpisodes() {
        return this.episodes;
    }

    @NotNull
    public final TraktCheckinApi getCheckin() {
        return this.checkin;
    }

    @NotNull
    public final TraktSearchApi getSearch() {
        return this.search;
    }
}

