/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.trakt.core;

import app.moviebase.trakt.TraktAuthCredentials;
import app.moviebase.trakt.TraktClientConfig;
import app.moviebase.trakt.core.JsonFactory;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientJvmKt;
import io.ktor.client.network.sockets.ConnectTimeoutException;
import io.ktor.client.plugins.DefaultRequest;
import io.ktor.client.plugins.DefaultRequestKt;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpRequestRetryConfig;
import io.ktor.client.plugins.HttpRequestRetryKt;
import io.ktor.client.plugins.HttpRequestTimeoutException;
import io.ktor.client.plugins.HttpRetryShouldRetryContext;
import io.ktor.client.plugins.HttpTimeoutConfig;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.plugins.auth.AuthConfig;
import io.ktor.client.plugins.auth.AuthKt;
import io.ktor.client.plugins.auth.providers.BearerAuthConfig;
import io.ktor.client.plugins.auth.providers.BearerAuthProviderKt;
import io.ktor.client.plugins.auth.providers.BearerTokens;
import io.ktor.client.plugins.auth.providers.RefreshTokensParams;
import io.ktor.client.plugins.cache.HttpCache;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiationConfig;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiationKt;
import io.ktor.client.plugins.logging.LoggingConfig;
import io.ktor.client.plugins.logging.LoggingKt;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.utils.ExceptionUtilsJvmKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLProtocol;
import io.ktor.serialization.Configuration;
import io.ktor.serialization.kotlinx.json.JsonSupportKt;
import java.net.SocketTimeoutException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0003\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lapp/moviebase/trakt/core/HttpClientFactory;", "", "<init>", "()V", "create", "Lio/ktor/client/HttpClient;", "config", "Lapp/moviebase/trakt/TraktClientConfig;", "isTimeoutException", "", "", "lib"})
public final class HttpClientFactory {
    @NotNull
    public static final HttpClientFactory INSTANCE = new HttpClientFactory();

    private HttpClientFactory() {
    }

    @NotNull
    public final HttpClient create(@NotNull TraktClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Function1 defaultConfig2 = arg_0 -> HttpClientFactory.create$lambda$12(config, arg_0);
        HttpClient httpClient = config.getHttpClientBuilder$lib();
        if (httpClient == null || (httpClient = (HttpClient)httpClient.invoke()) == null || (httpClient = httpClient.config(defaultConfig2)) == null) {
            httpClient = HttpClientJvmKt.HttpClient((Function1)defaultConfig2);
        }
        return httpClient;
    }

    private final boolean isTimeoutException(Throwable $this$isTimeoutException) {
        Throwable exception = ExceptionUtilsJvmKt.unwrapCancellationException((Throwable)$this$isTimeoutException);
        return exception instanceof HttpRequestTimeoutException || exception instanceof ConnectTimeoutException || exception instanceof SocketTimeoutException;
    }

    private static final Unit create$lambda$12$lambda$1$lambda$0(URLBuilder $this$url) {
        Intrinsics.checkNotNullParameter((Object)$this$url, (String)"$this$url");
        $this$url.setProtocol(URLProtocol.Companion.getHTTPS());
        $this$url.setHost("api.trakt.tv");
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$12$lambda$1(DefaultRequest.DefaultRequestBuilder $this$defaultRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultRequest, (String)"$this$defaultRequest");
        $this$defaultRequest.url(HttpClientFactory::create$lambda$12$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$12$lambda$2(Json $json, ContentNegotiationConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        JsonSupportKt.json$default((Configuration)((Configuration)$this$install), (Json)$json, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final boolean create$lambda$12$lambda$5$lambda$4$lambda$3(HttpRequestBuilder request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return Intrinsics.areEqual((Object)request.getUrl().getHost(), (Object)"api.trakt.tv");
    }

    private static final Unit create$lambda$12$lambda$5$lambda$4(TraktAuthCredentials $authCredentials, BearerAuthConfig $this$bearer) {
        Intrinsics.checkNotNullParameter((Object)$this$bearer, (String)"$this$bearer");
        $this$bearer.loadTokens((Function1)new Function1<Continuation<? super BearerTokens>, Object>($authCredentials, null){
            int label;
            final /* synthetic */ TraktAuthCredentials $authCredentials;
            {
                this.$authCredentials = $authCredentials;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$authCredentials.getLoadTokensProvider$lib().invoke((Object)((Object)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super BearerTokens> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
        $this$bearer.refreshTokens((Function2)new Function2<RefreshTokensParams, Continuation<? super BearerTokens>, Object>($authCredentials, null){
            int label;
            final /* synthetic */ TraktAuthCredentials $authCredentials;
            {
                this.$authCredentials = $authCredentials;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$authCredentials.getRefreshTokensProvider$lib().invoke((Object)((Object)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(RefreshTokensParams p1, Continuation<? super BearerTokens> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        $this$bearer.sendWithoutRequest(HttpClientFactory::create$lambda$12$lambda$5$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$12$lambda$5(TraktAuthCredentials $authCredentials, AuthConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        BearerAuthProviderKt.bearer((AuthConfig)$this$install, arg_0 -> HttpClientFactory.create$lambda$12$lambda$5$lambda$4($authCredentials, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean create$lambda$12$lambda$9$lambda$8$lambda$6(HttpRetryShouldRetryContext $this$retryIf, HttpRequest httpRequest, HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)$this$retryIf, (String)"$this$retryIf");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        int n = httpResponse.getStatus().getValue();
        return (500 <= n ? n < 600 : false) ? true : Intrinsics.areEqual((Object)httpResponse.getStatus(), (Object)HttpStatusCode.Companion.getTooManyRequests());
    }

    private static final boolean create$lambda$12$lambda$9$lambda$8$lambda$7(HttpRetryShouldRetryContext $this$retryOnExceptionIf, HttpRequestBuilder httpRequestBuilder, Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)$this$retryOnExceptionIf, (String)"$this$retryOnExceptionIf");
        Intrinsics.checkNotNullParameter((Object)httpRequestBuilder, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        return INSTANCE.isTimeoutException(cause) ? false : !(cause instanceof CancellationException);
    }

    private static final Unit create$lambda$12$lambda$9$lambda$8(int $it, HttpRequestRetryConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        HttpRequestRetryConfig.exponentialDelay$default((HttpRequestRetryConfig)$this$install, (double)0.0, (long)0L, (long)0L, (long)0L, (boolean)false, (int)31, null);
        $this$install.retryIf($it, HttpClientFactory::create$lambda$12$lambda$9$lambda$8$lambda$6);
        $this$install.retryOnExceptionIf($it, HttpClientFactory::create$lambda$12$lambda$9$lambda$8$lambda$7);
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$12$lambda$10(HttpTimeoutConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setRequestTimeoutMillis(Long.valueOf(60000L));
        $this$install.setConnectTimeoutMillis(Long.valueOf(60000L));
        $this$install.setSocketTimeoutMillis(Long.valueOf(60000L));
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$12(TraktClientConfig $config, HttpClientConfig httpClientConfig) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)httpClientConfig, (String)"<this>");
            Json json = JsonFactory.INSTANCE.create();
            DefaultRequestKt.defaultRequest((HttpClientConfig)httpClientConfig, HttpClientFactory::create$lambda$12$lambda$1);
            httpClientConfig.install((HttpClientPlugin)ContentNegotiationKt.getContentNegotiation(), arg_0 -> HttpClientFactory.create$lambda$12$lambda$2(json, arg_0));
            TraktAuthCredentials authCredentials = $config.getTraktAuthCredentials$lib();
            if (authCredentials != null) {
                httpClientConfig.install((HttpClientPlugin)AuthKt.getAuth(), arg_0 -> HttpClientFactory.create$lambda$12$lambda$5(authCredentials, arg_0));
            }
            httpClientConfig.setExpectSuccess($config.getExpectSuccess());
            Integer n = $config.getMaxRequestRetries();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                httpClientConfig.install((HttpClientPlugin)HttpRequestRetryKt.getHttpRequestRetry(), arg_0 -> HttpClientFactory.create$lambda$12$lambda$9$lambda$8(it, arg_0));
            }
            if ($config.getUseCache()) {
                HttpClientConfig.install$default((HttpClientConfig)httpClientConfig, (HttpClientPlugin)((HttpClientPlugin)HttpCache.Companion), null, (int)2, null);
            }
            if ($config.getUseTimeout()) {
                httpClientConfig.install((HttpClientPlugin)HttpTimeoutKt.getHttpTimeout(), HttpClientFactory::create$lambda$12$lambda$10);
            }
            Function1<LoggingConfig, Unit> function1 = $config.getHttpClientLoggingBlock$lib();
            if (function1 != null) {
                Function1<LoggingConfig, Unit> it = function1;
                boolean bl = false;
                LoggingKt.Logging((HttpClientConfig)httpClientConfig, it);
            }
            Function1<HttpClientConfig<?>, Unit> function12 = $config.getHttpClientConfigBlock$lib();
            if (function12 == null) break block5;
            function12.invoke((Object)httpClientConfig);
        }
        return Unit.INSTANCE;
    }
}

