/*
 * Decompiled with CFR 0.152.
 */
package app.moviebase.trakt.url;

import app.moviebase.trakt.model.TraktMediaType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ3\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lapp/moviebase/trakt/url/TraktUrlBuilder;", "", "<init>", "()V", "buildUserPage", "", "userId", "buildCommentPage", "commentId", "", "buildMediaPage", "mediaType", "Lapp/moviebase/trakt/model/TraktMediaType;", "imdbOrTraktId", "seasonNumber", "episodeNumber", "(Lapp/moviebase/trakt/model/TraktMediaType;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/String;", "lib"})
public final class TraktUrlBuilder {
    @NotNull
    public static final TraktUrlBuilder INSTANCE = new TraktUrlBuilder();

    private TraktUrlBuilder() {
    }

    @NotNull
    public final String buildUserPage(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return "https://trakt.tv/users/" + userId;
    }

    @NotNull
    public final String buildCommentPage(int commentId) {
        return "https://trakt.tv/comments/" + commentId;
    }

    @NotNull
    public final String buildMediaPage(@NotNull TraktMediaType mediaType, @NotNull String imdbOrTraktId, @Nullable Integer seasonNumber, @Nullable Integer episodeNumber) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter((Object)imdbOrTraktId, (String)"imdbOrTraktId");
        if (StringsKt.startsWith$default((String)imdbOrTraktId, (String)"tt", (boolean)false, (int)2, null)) {
            return "https://trakt.tv/search/imdb/" + imdbOrTraktId;
        }
        String mediaTypeParam = mediaType == TraktMediaType.MOVIE ? "movies" : "shows";
        String path = "https://trakt.tv/" + mediaTypeParam + "/" + imdbOrTraktId;
        if (mediaType == TraktMediaType.SEASON) {
            path = path + "/seasons/" + seasonNumber;
        }
        if (mediaType == TraktMediaType.EPISODE) {
            path = path + "/episodes/" + episodeNumber;
        }
        return path;
    }

    public static /* synthetic */ String buildMediaPage$default(TraktUrlBuilder traktUrlBuilder, TraktMediaType traktMediaType, String string, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return traktUrlBuilder.buildMediaPage(traktMediaType, string, n, n2);
    }
}

