/*
 * Decompiled with CFR 0.152.
 */
package com.darkrockstudios.libraries.mpfilepicker.windows.api;

import androidx.compose.runtime.internal.StabilityInferred;
import com.darkrockstudios.libraries.mpfilepicker.windows.api.WindowsFileChooser;
import com.darkrockstudios.libraries.mpfilepicker.windows.api.WindowsFolderBrowser;
import com.sun.jna.Platform;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0007\u0018\u00002\u00020\u0001:\u0002DEB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0013\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0010\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010.J\u000e\u0010/\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.J\u001a\u00100\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u000202H\u0002J\u001a\u00103\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u000202H\u0002J\u001a\u00104\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u000202H\u0002J\u0012\u00105\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J'\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\b2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000b\"\u00020\b\u00a2\u0006\u0002\u0010:J\u0010\u0010\u0014\u001a\u0002072\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020\bJ\u000e\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020\bJ\u000e\u0010?\u001a\u0002072\u0006\u0010@\u001a\u00020\bJ\u000e\u0010A\u001a\u0002072\u0006\u0010@\u001a\u00020\bR6\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b@DX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0006R8\u0010\u0015\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\u0017j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b`\u0016X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010B\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0013\u00a8\u0006F"}, d2={"Lcom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser;", "", "<init>", "()V", "currentDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "currentDirectoryPath", "", "(Ljava/lang/String;)V", "value", "", "selectedFiles", "getSelectedFiles", "()[Ljava/io/File;", "setSelectedFiles", "([Ljava/io/File;)V", "[Ljava/io/File;", "getCurrentDirectory", "()Ljava/io/File;", "setCurrentDirectory", "filters", "Lkotlin/collections/ArrayList;", "Ljava/util/ArrayList;", "getFilters", "()Ljava/util/ArrayList;", "setFilters", "(Ljava/util/ArrayList;)V", "Ljava/util/ArrayList;", "isMultiSelectionEnabled", "", "()Z", "setMultiSelectionEnabled", "(Z)V", "mode", "Lcom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser$Mode;", "getMode", "()Lcom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser$Mode;", "setMode", "(Lcom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser$Mode;)V", "defaultFile", "dialogTitle", "openButtonText", "saveButtonText", "showOpenDialog", "parent", "Ljava/awt/Window;", "showSaveDialog", "showDialog", "action", "Lcom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser$Action;", "showSwingFileChooser", "showWindowsFileChooser", "showWindowsFolderBrowser", "addFilter", "", "name", "filter", "(Ljava/lang/String;[Ljava/lang/String;)V", "setDefaultFileName", "dfile", "setTitle", "title", "setOpenButtonText", "buttonText", "setSaveButtonText", "selectedFile", "getSelectedFile", "Action", "Mode", "mpfilepicker"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nJnaFileChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JnaFileChooser.kt\ncom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,298:1\n37#2,2:299\n*S KotlinDebug\n*F\n+ 1 JnaFileChooser.kt\ncom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser\n*L\n256#1:299,2\n*E\n"})
public final class JnaFileChooser {
    @NotNull
    private File[] selectedFiles;
    @Nullable
    private File currentDirectory;
    @NotNull
    private ArrayList<String[]> filters = new ArrayList();
    private boolean isMultiSelectionEnabled;
    @NotNull
    private Mode mode = Mode.Files;
    @NotNull
    private String defaultFile = "";
    @NotNull
    private String dialogTitle = "";
    @NotNull
    private String openButtonText = "";
    @NotNull
    private String saveButtonText = "";
    public static final int $stable = 8;

    public JnaFileChooser() {
        File[] fileArray = new File[]{null};
        this.selectedFiles = fileArray;
    }

    @NotNull
    public final File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    protected final void setSelectedFiles(@NotNull File[] fileArray) {
        Intrinsics.checkNotNullParameter((Object)fileArray, (String)"<set-?>");
        this.selectedFiles = fileArray;
    }

    @Nullable
    public final File getCurrentDirectory() {
        return this.currentDirectory;
    }

    protected final void setCurrentDirectory(@Nullable File file) {
        this.currentDirectory = file;
    }

    @NotNull
    protected final ArrayList<String[]> getFilters() {
        return this.filters;
    }

    protected final void setFilters(@NotNull ArrayList<String[]> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.filters = arrayList;
    }

    public final boolean isMultiSelectionEnabled() {
        return this.isMultiSelectionEnabled;
    }

    public final void setMultiSelectionEnabled(boolean bl) {
        this.isMultiSelectionEnabled = bl;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"<set-?>");
        this.mode = mode;
    }

    public JnaFileChooser(@Nullable File currentDirectory) {
        this();
        if (currentDirectory != null) {
            this.currentDirectory = currentDirectory.isDirectory() ? currentDirectory : currentDirectory.getParentFile();
        }
    }

    public JnaFileChooser(@Nullable String currentDirectoryPath) {
        this(currentDirectoryPath != null ? new File(currentDirectoryPath) : null);
    }

    public final boolean showOpenDialog(@Nullable Window parent) {
        return this.showDialog(parent, Action.Open);
    }

    public final boolean showSaveDialog(@NotNull Window parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.showDialog(parent, Action.Save);
    }

    private final boolean showDialog(Window parent, Action action) {
        if (!(!Platform.isWindows() || this.mode == Mode.FilesAndDirectories || this.isMultiSelectionEnabled && this.mode == Mode.Files || this.isMultiSelectionEnabled)) {
            if (this.mode == Mode.Files) {
                return this.showWindowsFileChooser(parent, action);
            }
            if (this.mode == Mode.Directories) {
                return this.showWindowsFolderBrowser(parent);
            }
        }
        return this.showSwingFileChooser(parent, action);
    }

    private final boolean showSwingFileChooser(Window parent, Action action) {
        File[] fileArray;
        JFileChooser fc = new JFileChooser(this.currentDirectory);
        fc.setMultiSelectionEnabled(this.isMultiSelectionEnabled);
        fc.setFileSelectionMode(this.mode.getJFileChooserValue());
        if (!(((CharSequence)this.defaultFile).length() == 0) & action == Action.Save) {
            File fsel = new File(this.defaultFile);
            fc.setSelectedFile(fsel);
        }
        if (!(((CharSequence)this.dialogTitle).length() == 0)) {
            fc.setDialogTitle(this.dialogTitle);
        }
        if (action == Action.Open & !(((CharSequence)this.openButtonText).length() == 0)) {
            fc.setApproveButtonText(this.openButtonText);
        } else if (action == Action.Save & !(((CharSequence)this.saveButtonText).length() == 0)) {
            fc.setApproveButtonText(this.saveButtonText);
        }
        if (this.filters.size() > 0) {
            boolean useAcceptAllFilter = false;
            File[] fileArray2 = this.filters.iterator();
            Intrinsics.checkNotNullExpressionValue(fileArray2, (String)"iterator(...)");
            fileArray = fileArray2;
            while (fileArray.hasNext()) {
                String[] spec;
                Intrinsics.checkNotNullExpressionValue((Object)fileArray.next(), (String)"next(...)");
                if (Intrinsics.areEqual((Object)spec[1], (Object)"*")) {
                    useAcceptAllFilter = true;
                    continue;
                }
                String[] stringArray = Arrays.copyOfRange(spec, 1, spec.length);
                fc.addChoosableFileFilter(new FileNameExtensionFilter(spec[0], Arrays.copyOf(stringArray, stringArray.length)));
            }
            fc.setAcceptAllFileFilterUsed(useAcceptAllFilter);
        }
        int result = -1;
        int n = action == Action.Open ? fc.showOpenDialog(parent) : (result = ((CharSequence)this.saveButtonText).length() == 0 ? fc.showSaveDialog(parent) : fc.showDialog(parent, null));
        if (result == 0) {
            File[] fileArray3;
            if (this.isMultiSelectionEnabled) {
                File[] fileArray4 = fc.getSelectedFiles();
                fileArray3 = fileArray4;
                Intrinsics.checkNotNullExpressionValue((Object)fileArray4, (String)"getSelectedFiles(...)");
            } else {
                fileArray = new File[]{fc.getSelectedFile()};
                fileArray3 = fileArray;
            }
            this.selectedFiles = fileArray3;
            this.currentDirectory = fc.getCurrentDirectory();
            return true;
        }
        return false;
    }

    private final boolean showWindowsFileChooser(Window parent, Action action) {
        boolean result;
        WindowsFileChooser fc = new WindowsFileChooser(this.currentDirectory);
        fc.setFilters(this.filters);
        if (!(((CharSequence)this.defaultFile).length() == 0)) {
            fc.setDefaultFilename(this.defaultFile);
        }
        if (!(((CharSequence)this.dialogTitle).length() == 0)) {
            fc.setTitle(this.dialogTitle);
        }
        if (result = fc.showDialog(parent, action == Action.Open)) {
            File[] fileArray = new File[]{fc.getSelectedFile()};
            this.selectedFiles = fileArray;
            this.currentDirectory = fc.getCurrentDirectory();
        }
        return result;
    }

    private final boolean showWindowsFolderBrowser(Window parent) {
        File file;
        WindowsFolderBrowser fb = new WindowsFolderBrowser();
        if (!(((CharSequence)this.dialogTitle).length() == 0)) {
            fb.setTitle(this.dialogTitle);
        }
        if ((file = fb.showDialog(parent)) != null) {
            File[] fileArray = new File[]{file};
            this.selectedFiles = fileArray;
            this.currentDirectory = file.getParentFile() != null ? file.getParentFile() : file;
            return true;
        }
        return false;
    }

    public final void addFilter(@NotNull String name, String ... filter) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(!(filter.length == 0))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(name);
        Collections.addAll((Collection)parts, Arrays.copyOf(filter, filter.length));
        Collection $this$toTypedArray$iv = parts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.filters.add(thisCollection$iv.toArray(new String[0]));
    }

    public final void setCurrentDirectory(@Nullable String currentDirectoryPath) {
        this.currentDirectory = currentDirectoryPath != null ? new File(currentDirectoryPath) : null;
    }

    public final void setDefaultFileName(@NotNull String dfile) {
        Intrinsics.checkNotNullParameter((Object)dfile, (String)"dfile");
        this.defaultFile = dfile;
    }

    public final void setTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.dialogTitle = title;
    }

    public final void setOpenButtonText(@NotNull String buttonText) {
        Intrinsics.checkNotNullParameter((Object)buttonText, (String)"buttonText");
        this.openButtonText = buttonText;
    }

    public final void setSaveButtonText(@NotNull String buttonText) {
        Intrinsics.checkNotNullParameter((Object)buttonText, (String)"buttonText");
        this.saveButtonText = buttonText;
    }

    @Nullable
    public final File getSelectedFile() {
        return this.selectedFiles[0];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser$Action;", "", "<init>", "(Ljava/lang/String;I)V", "Open", "Save", "mpfilepicker"})
    private static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action Open = new Action();
        public static final /* enum */ Action Save = new Action();
        private static final /* synthetic */ Action[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        @NotNull
        public static EnumEntries<Action> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = actionArray = new Action[]{Action.Open, Action.Save};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/darkrockstudios/libraries/mpfilepicker/windows/api/JnaFileChooser$Mode;", "", "jFileChooserValue", "", "<init>", "(Ljava/lang/String;II)V", "getJFileChooserValue", "()I", "Files", "Directories", "FilesAndDirectories", "mpfilepicker"})
    public static final class Mode
    extends Enum<Mode> {
        private final int jFileChooserValue;
        public static final /* enum */ Mode Files = new Mode(0);
        public static final /* enum */ Mode Directories = new Mode(1);
        public static final /* enum */ Mode FilesAndDirectories = new Mode(2);
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Mode(int jFileChooserValue) {
            this.jFileChooserValue = jFileChooserValue;
        }

        public final int getJFileChooserValue() {
            return this.jFileChooserValue;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Files, Mode.Directories, Mode.FilesAndDirectories};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

