/**
 * DO NOT EDIT THIS FILE! This file is auto-generated by executing `gradle
 * :prism4j:regenerateDefaultGrammarLocator` and should not be edited by you!
 */
package io.noties.prism4j;

import io.noties.prism4j.languages.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class DefaultGrammarLocator implements GrammarLocator {

    public DefaultGrammarLocator() {
        this(false, null);
    }

    /**
     * Constructor to allow initialization of all languages before requesting them. If you do not
     * want to initialize them, please use {@link #DefaultGrammarLocator()}.
     *
     * @param initLanguages set this to true or use {@link #DefaultGrammarLocator()}
     * @param prism4j the {@link Prism4j} object
     */
    public DefaultGrammarLocator(boolean initLanguages, @Nullable Prism4j prism4j) {
        if (initLanguages && prism4j != null) {
            for (String i : languages()) {
                grammar(prism4j, i);
            }
        }
    }

    @SuppressWarnings("ConstantConditions")
    private static final Grammar NULL =
            new Grammar("", new ArrayList<>()) {
                @NotNull
                @Override
                public String name() {
                    return null;
                }

                @NotNull
                @Override
                public List<Token> tokens() {
                    return null;
                }
            };

    private final HashMap<String, Grammar> cache = new HashMap<>(3);

    @Nullable
    @Override
    public Grammar grammar(@NotNull Prism4j prism4j, @NotNull String language) {

        final String name = realLanguageName(language);

        Grammar grammar = cache.get(name);
        if (grammar != null) {
            if (NULL == grammar) {
                grammar = null;
            }
            return grammar;
        }

        grammar = obtainGrammar(prism4j, name);
        if (grammar == null) {
            cache.put(name, NULL);
        } else {
            cache.put(name, grammar);
        }

        return grammar;
    }

    @NotNull
    protected String realLanguageName(@NotNull String name) {
        final String out;
        switch (name) {
            case "shell":
                out = "bash";
                break;
            case "dotnet":
                out = "csharp";
                break;
            case "js":
                out = "javascript";
                break;
            case "webmanifest":
                out = "json";
                break;
            case "kt":
            case "kts":
                out = "kotlin";
                break;
            case "tex":
            case "context":
                out = "latex";
                break;
            case "xml":
            case "html":
            case "mathml":
            case "svg":
                out = "markup";
                break;
            case "yml":
                out = "yaml";
                break;
            default:
                out = name;
        }
        return out;
    }

    @Nullable
    protected Grammar obtainGrammar(@NotNull Prism4j prism4j, @NotNull String name) {
        final Grammar grammar;
        switch (name) {
            case "bash":
                grammar = Prism_bash.create(prism4j);
                break;
            case "basic":
                grammar = Prism_basic.create(prism4j);
                break;
            case "brainfuck":
                grammar = Prism_brainfuck.create(prism4j);
                break;
            case "c":
                grammar = Prism_c.create(prism4j);
                break;
            case "clike":
                grammar = Prism_clike.create(prism4j);
                break;
            case "clojure":
                grammar = Prism_clojure.create(prism4j);
                break;
            case "cpp":
                grammar = Prism_cpp.create(prism4j);
                break;
            case "csharp":
                grammar = Prism_csharp.create(prism4j);
                break;
            case "css":
                grammar = Prism_css.create(prism4j);
                break;
            case "csv":
                grammar = Prism_csv.create(prism4j);
                break;
            case "dart":
                grammar = Prism_dart.create(prism4j);
                break;
            case "diff":
                grammar = Prism_diff.create(prism4j);
                break;
            case "git":
                grammar = Prism_git.create(prism4j);
                break;
            case "go":
                grammar = Prism_go.create(prism4j);
                break;
            case "groovy":
                grammar = Prism_groovy.create(prism4j);
                break;
            case "haxe":
                grammar = Prism_haxe.create(prism4j);
                break;
            case "ini":
                grammar = Prism_ini.create(prism4j);
                break;
            case "java":
                grammar = Prism_java.create(prism4j);
                break;
            case "javascript":
                grammar = Prism_javascript.create(prism4j);
                break;
            case "json":
                grammar = Prism_json.create(prism4j);
                break;
            case "jsonp":
                grammar = Prism_jsonp.create(prism4j);
                break;
            case "kotlin":
                grammar = Prism_kotlin.create(prism4j);
                break;
            case "latex":
                grammar = Prism_latex.create(prism4j);
                break;
            case "makefile":
                grammar = Prism_makefile.create(prism4j);
                break;
            case "markdown":
                grammar = Prism_markdown.create(prism4j);
                break;
            case "markup":
                grammar = Prism_markup.create(prism4j);
                break;
            case "python":
                grammar = Prism_python.create(prism4j);
                break;
            case "regex":
                grammar = Prism_regex.create(prism4j);
                break;
            case "scala":
                grammar = Prism_scala.create(prism4j);
                break;
            case "sql":
                grammar = Prism_sql.create(prism4j);
                break;
            case "swift":
                grammar = Prism_swift.create(prism4j);
                break;
            case "yaml":
                grammar = Prism_yaml.create(prism4j);
                break;
            default:
                grammar = null;
        }
        return grammar;
    }

    @Override
    @NotNull
    public HashSet<String> languages() {
        final HashSet<String> set = new HashSet<>(32);
        set.add("bash");
        set.add("basic");
        set.add("brainfuck");
        set.add("c");
        set.add("clike");
        set.add("clojure");
        set.add("cpp");
        set.add("csharp");
        set.add("css");
        set.add("csv");
        set.add("dart");
        set.add("diff");
        set.add("git");
        set.add("go");
        set.add("groovy");
        set.add("haxe");
        set.add("ini");
        set.add("java");
        set.add("javascript");
        set.add("json");
        set.add("jsonp");
        set.add("kotlin");
        set.add("latex");
        set.add("makefile");
        set.add("markdown");
        set.add("markup");
        set.add("python");
        set.add("regex");
        set.add("scala");
        set.add("sql");
        set.add("swift");
        set.add("yaml");
        return set;
    }
}
