/*
 * Decompiled with CFR 0.152.
 */
package io.noties.prism4j;

import io.noties.prism4j.Pattern;
import io.noties.prism4j.ToString;
import io.noties.prism4j.Token;
import io.noties.prism4j.languages.GrammarUtils;
import io.noties.prism4j.languages.TokenFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Grammar {
    private final String name;
    private final List<Token> tokens;

    public Grammar(@NotNull String name, @NotNull List<Token> tokens) {
        this.name = name;
        this.tokens = tokens;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @NotNull
    public List<Token> tokens() {
        return this.tokens;
    }

    public String toString() {
        return ToString.toString(this);
    }

    @NotNull
    public Grammar extend(@NotNull String name, Token ... tokens) {
        int size;
        int n = size = tokens != null ? tokens.length : 0;
        if (size == 0) {
            return new Grammar(name, GrammarUtils.clone(this).tokens());
        }
        HashMap<String, Token> overrides = new HashMap<String, Token>(size);
        for (Token token : tokens) {
            overrides.put(token.name(), token);
        }
        List<Token> origins = this.tokens();
        ArrayList<Token> out = new ArrayList<Token>(origins.size());
        for (Token origin : origins) {
            Token override = (Token)overrides.get(origin.name());
            if (override != null) {
                out.add(override);
                continue;
            }
            out.add(GrammarUtils.clone(origin));
        }
        return new Grammar(name, out);
    }

    @NotNull
    public Grammar extend(@NotNull String name, @NotNull TokenFilter filter, Token ... tokens) {
        Map<String, Token> overrides;
        int size;
        int n = size = tokens != null ? tokens.length : 0;
        if (size == 0) {
            overrides = Collections.emptyMap();
        } else {
            overrides = new HashMap(size);
            for (Token token : tokens) {
                overrides.put(token.name(), token);
            }
        }
        List<Token> origins = this.tokens();
        ArrayList<Token> out = new ArrayList<Token>(origins.size());
        for (Token origin : origins) {
            if (!filter.test(origin)) continue;
            Token override = (Token)overrides.get(origin.name());
            if (override != null) {
                out.add(override);
                continue;
            }
            out.add(GrammarUtils.clone(origin));
        }
        return new Grammar(name, out);
    }

    @Nullable
    public Token findToken(@NotNull String path) {
        String[] parts = path.split("/");
        return this.findToken(parts, 0);
    }

    @Nullable
    private Token findToken(@NotNull String[] parts, int index) {
        String part = parts[index];
        boolean last = index == parts.length - 1;
        for (Token token : this.tokens()) {
            if (!part.equals(token.name())) continue;
            if (last) {
                return token;
            }
            Grammar inside = Grammar.findFirstInsideGrammar(token);
            if (inside == null) break;
            return this.findToken(parts, index + 1);
        }
        return null;
    }

    public void insertBeforeToken(@NotNull String path, Token ... tokens) {
        if (tokens == null || tokens.length == 0) {
            return;
        }
        String[] parts = path.split("/");
        this.insertBeforeToken(this, parts, 0, tokens);
    }

    private void insertBeforeToken(@NotNull Grammar grammar, @NotNull String[] parts, int index, @NotNull Token[] tokens) {
        String part = parts[index];
        boolean last = index == parts.length - 1;
        List<Token> grammarTokens = grammar.tokens();
        int size = grammarTokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = grammarTokens.get(i);
            if (!part.equals(token.name())) continue;
            if (last) {
                Grammar.insertTokensAt(i, grammarTokens, tokens);
                break;
            }
            Grammar inside = Grammar.findFirstInsideGrammar(token);
            if (inside == null) break;
            this.insertBeforeToken(inside, parts, index + 1, tokens);
            break;
        }
    }

    @Nullable
    public static Grammar findFirstInsideGrammar(@NotNull Token token) {
        Grammar grammar = null;
        for (Pattern pattern : token.patterns()) {
            if (pattern.inside() == null) continue;
            grammar = pattern.inside();
            break;
        }
        return grammar;
    }

    private static void insertTokensAt(int start, @NotNull List<Token> grammarTokens, @NotNull Token[] tokens) {
        int length = tokens.length;
        for (int i = 0; i < length; ++i) {
            grammarTokens.add(start + i, tokens[i]);
        }
    }
}

