/*
 * Decompiled with CFR 0.152.
 */
package io.noties.prism4j;

import io.noties.prism4j.DefaultGrammarLocator;
import io.noties.prism4j.Grammar;
import io.noties.prism4j.GrammarLocator;
import io.noties.prism4j.Node;
import io.noties.prism4j.Pattern;
import io.noties.prism4j.Syntax;
import io.noties.prism4j.Text;
import io.noties.prism4j.Token;
import io.noties.prism4j.Visitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Prism4j {
    private final GrammarLocator grammarLocator;

    public Prism4j() {
        this(new DefaultGrammarLocator());
    }

    public Prism4j(@NotNull GrammarLocator grammarLocator) {
        this.grammarLocator = grammarLocator;
    }

    private static boolean isSyntaxNode(@NotNull Node node) {
        return node.isSyntax();
    }

    private static boolean isGreedyNode(@NotNull Node node) {
        return node.isSyntax() && ((Syntax)node).greedy();
    }

    @NotNull
    public List<Node> tokenize(@NotNull String text, @NotNull Grammar grammar) {
        ArrayList<Node> entries = new ArrayList<Node>(3);
        entries.add(new Text(text));
        if (text.length() > 0) {
            this.matchGrammar(text, entries, grammar, 0, 0, false, null);
        }
        return entries;
    }

    @NotNull
    public List<Node> tokenize(@NotNull String text, @NotNull String languageName) {
        return this.tokenize(text, this.requireGrammar(languageName));
    }

    public void visit(@NotNull Visitor visitor, @NotNull String text, @NotNull Grammar grammar) {
        visitor.visit(this.tokenize(text, grammar));
    }

    public void visit(@NotNull Visitor visitor, @NotNull String text, @NotNull String languageName) {
        this.visit(visitor, text, this.requireGrammar(languageName));
    }

    @Nullable
    public Grammar grammar(@NotNull String name) {
        return this.grammarLocator.grammar(this, name);
    }

    @NotNull
    public Grammar requireGrammar(@NotNull String name) {
        Grammar grammar = this.grammar(name);
        if (grammar == null) {
            throw new NullPointerException("Requested language is not found: " + name);
        }
        return grammar;
    }

    private void matchGrammar(@NotNull String text, @NotNull List<Node> entries, @NotNull Grammar grammar, int index, int startPosition, boolean oneShot, @Nullable Token target) {
        int textLength = text.length();
        for (Token token : grammar.tokens()) {
            if (token == target) {
                return;
            }
            block1: for (Pattern pattern : token.patterns()) {
                boolean lookbehind = pattern.lookbehind();
                boolean greedy = pattern.greedy();
                int lookbehindLength = 0;
                java.util.regex.Pattern regex = pattern.regex();
                int position = startPosition;
                for (int i = index; i < entries.size(); ++i) {
                    block15: {
                        boolean greedyMatch;
                        int deleteCount;
                        int from;
                        Matcher matcher;
                        int greedyAdd;
                        String str;
                        block17: {
                            block16: {
                                int k;
                                if (entries.size() > textLength) {
                                    throw new RuntimeException("Prism4j internal error. Number of entry nodes is greater that the text length.\nNodes: " + entries + "\nText: " + text);
                                }
                                Node node = entries.get(i);
                                if (Prism4j.isSyntaxNode(node)) break block15;
                                str = ((Text)node).literal();
                                greedyAdd = 0;
                                if (!greedy || i == entries.size() - 1) break block16;
                                matcher = regex.matcher(text);
                                matcher.region(position, textLength);
                                if (!matcher.find()) continue block1;
                                from = matcher.start();
                                if (lookbehind) {
                                    from += matcher.group(1).length();
                                }
                                int to = matcher.start() + matcher.group(0).length();
                                int p = position;
                                int len = entries.size();
                                for (k = i; k < len && (p < to || !Prism4j.isSyntaxNode(entries.get(k)) && !Prism4j.isGreedyNode(entries.get(k - 1))); ++k) {
                                    if (from < (p += entries.get(k).textLength())) continue;
                                    ++i;
                                    position = p;
                                }
                                if (Prism4j.isSyntaxNode(entries.get(i))) break block15;
                                deleteCount = k - i;
                                str = text.substring(position, p);
                                greedyMatch = true;
                                greedyAdd = -position;
                                break block17;
                            }
                            matcher = regex.matcher(str);
                            deleteCount = 1;
                            greedyMatch = false;
                        }
                        if (!greedyMatch && !matcher.find()) {
                            if (oneShot) {
                                continue block1;
                            }
                        } else {
                            Grammar inside;
                            if (lookbehind) {
                                String group = matcher.group(1);
                                lookbehindLength = group != null ? group.length() : 0;
                            }
                            from = matcher.start() + greedyAdd + lookbehindLength;
                            String match = lookbehindLength > 0 ? matcher.group().substring(lookbehindLength) : matcher.group();
                            int to = from + match.length();
                            for (int d = 0; d < deleteCount; ++d) {
                                entries.remove(i);
                            }
                            int i2 = i++;
                            if (from != 0) {
                                String before = str.substring(0, from);
                                position += before.length();
                                entries.add(i2++, new Text(before));
                            }
                            boolean hasInside = (inside = pattern.inside()) != null;
                            List<Node> tokenEntries = hasInside ? this.tokenize(match, inside) : Collections.singletonList(new Text(match));
                            entries.add(i2++, new Syntax(token.name(), tokenEntries, pattern.alias(), match, greedy, hasInside));
                            if (to < str.length()) {
                                String after = str.substring(to);
                                entries.add(i2, new Text(after));
                            }
                            if (deleteCount != 1) {
                                this.matchGrammar(text, entries, grammar, i, position, true, token);
                            }
                            if (oneShot) continue block1;
                        }
                    }
                    position += entries.get(i).textLength();
                }
            }
        }
    }
}

