/*
 * Decompiled with CFR 0.152.
 */
package io.noties.prism4j;

import io.noties.prism4j.Grammar;
import io.noties.prism4j.Pattern;
import io.noties.prism4j.Token;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class ToString {
    private ToString() {
    }

    @NotNull
    static String toString(@NotNull Grammar grammar) {
        StringBuilder builder = new StringBuilder();
        ToString.toString(builder, new Cache(), grammar);
        return builder.toString();
    }

    @NotNull
    static String toString(@NotNull Token token) {
        StringBuilder builder = new StringBuilder();
        ToString.toString(builder, new Cache(), token);
        return builder.toString();
    }

    @NotNull
    static String toString(@NotNull Pattern pattern) {
        StringBuilder builder = new StringBuilder();
        ToString.toString(builder, new Cache(), pattern);
        return builder.toString();
    }

    private static void toString(@NotNull StringBuilder builder, @NotNull Cache cache, @NotNull Grammar grammar) {
        builder.append("Grammar{id=0x").append(Integer.toHexString(System.identityHashCode(grammar))).append(",name=\"").append(grammar.name()).append('\"');
        if (cache.visited(grammar)) {
            builder.append(",[...]");
        } else {
            cache.markVisited(grammar);
            builder.append(",tokens=[");
            boolean first = true;
            for (Token token : grammar.tokens()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                ToString.toString(builder, cache, token);
            }
            builder.append(']');
        }
        builder.append('}');
    }

    private static void toString(@NotNull StringBuilder builder, @NotNull Cache cache, @NotNull Token token) {
        builder.append("Token{id=0x").append(Integer.toHexString(System.identityHashCode(token))).append(",name=\"").append(token.name()).append('\"');
        if (cache.visited(token)) {
            builder.append(",[...]");
        } else {
            cache.markVisited(token);
            builder.append(",patterns=[");
            boolean first = true;
            for (Pattern pattern : token.patterns()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                ToString.toString(builder, cache, pattern);
            }
            builder.append(']');
        }
        builder.append('}');
    }

    private static void toString(@NotNull StringBuilder builder, @NotNull Cache cache, @NotNull Pattern pattern) {
        builder.append("Pattern{id=0x").append(Integer.toHexString(System.identityHashCode(pattern)));
        if (cache.visited(pattern)) {
            builder.append(",[...]");
        } else {
            Grammar inside;
            cache.markVisited(pattern);
            builder.append(",regex=\"").append(pattern.regex()).append('\"');
            if (pattern.lookbehind()) {
                builder.append(",lookbehind=true");
            }
            if (pattern.greedy()) {
                builder.append(",greedy=true");
            }
            if (pattern.alias() != null) {
                builder.append(",alias=\"").append(pattern.alias()).append('\"');
            }
            if ((inside = pattern.inside()) != null) {
                builder.append(",inside=");
                ToString.toString(builder, cache, inside);
            }
        }
        builder.append('}');
    }

    private static class Cache {
        private final Set<Integer> cache = new HashSet<Integer>(3);

        private Cache() {
        }

        @NotNull
        private static Integer key(@NotNull Object o) {
            return System.identityHashCode(o);
        }

        public boolean visited(@NotNull Object o) {
            return this.cache.contains(Cache.key(o));
        }

        public void markVisited(@NotNull Object o) {
            this.cache.add(Cache.key(o));
        }
    }
}

