package cz.mroczis.netmonster.core.db

/**
 * Static table for conversion from MCC to ISO alpha 2 code.
 *
 * Taken from [Wikipedia](https://en.wikipedia.org/wiki/Mobile_country_code)
 */
object MccIsoTable {

    private val map = mutableMapOf<String, String>().apply {
        put("289", "GE-AB")
        put("412", "AF")
        put("276", "AL")
        put("603", "DZ")
        put("544", "AS")
        put("213", "AD")
        put("631", "AO")
        put("365", "AI")
        put("344", "AG")
        put("722", "AR")
        put("283", "AM")
        put("363", "AW")
        put("505", "AU")
        put("232", "AT")
        put("400", "AZ")
        put("364", "BS")
        put("426", "BH")
        put("470", "BD")
        put("342", "BB")
        put("257", "BY")
        put("206", "BE")
        put("702", "BZ")
        put("616", "BJ")
        put("350", "BM")
        put("402", "BT")
        put("736", "BO")
        put("362", "BQ")
        put("218", "BA")
        put("652", "BW")
        put("724", "BR")
        put("995", "IO")
        put("348", "VG")
        put("528", "BN")
        put("284", "BG")
        put("613", "BF")
        put("642", "BI")
        put("456", "KH")
        put("624", "CM")
        put("302", "CA")
        put("625", "CV")
        put("346", "KY")
        put("623", "CF")
        put("622", "TD")
        put("730", "CL")
        put("460", "CN")
        put("461", "CN")
        put("732", "CO")
        put("654", "KM")
        put("629", "CG")
        put("548", "CK")
        put("712", "CR")
        put("219", "HR")
        put("368", "CU")
        put("362", "CW")
        put("280", "CY")
        put("230", "CZ")
        put("630", "CD")
        put("238", "DK")
        put("638", "DJ")
        put("366", "DM")
        put("370", "DO")
        put("514", "TL")
        put("740", "EC")
        put("602", "EG")
        put("706", "SV")
        put("627", "GQ")
        put("657", "ER")
        put("248", "EE")
        put("636", "ET")
        put("750", "FK")
        put("288", "FO")
        put("542", "FJ")
        put("244", "FI")
        put("208", "FR")
        put("742", "GF")
        put("647", "RE")
        put("547", "PF")
        put("628", "GA")
        put("607", "GM")
        put("282", "GE")
        put("262", "DE")
        put("620", "GH")
        put("266", "GI")
        put("202", "GR")
        put("290", "GL")
        put("352", "GD")
        put("340", "GP")
        put("310", "GU")
        put("311", "GU")
        put("704", "GT")
        put("234", "GG")
        put("611", "GN")
        put("632", "GW")
        put("738", "GY")
        put("372", "HT")
        put("708", "HN")
        put("454", "HK")
        put("216", "HU")
        put("274", "IS")
        put("404", "IN")
        put("405", "IN")
        put("406", "IN")
        put("510", "ID")
        put("432", "IR")
        put("418", "IQ")
        put("272", "IE")
        put("234", "IM")
        put("425", "IL")
        put("222", "IT")
        put("612", "CI")
        put("338", "JM")
        put("440", "JP")
        put("441", "JP")
        put("234", "JE")
        put("416", "JO")
        put("401", "KZ")
        put("639", "KE")
        put("545", "KI")
        put("467", "KP")
        put("450", "KR")
        put("221", "XK")
        put("419", "KW")
        put("437", "KG")
        put("457", "LA")
        put("247", "LV")
        put("415", "LB")
        put("651", "LS")
        put("618", "LR")
        put("606", "LY")
        put("295", "LI")
        put("246", "LT")
        put("270", "LU")
        put("455", "MO")
        put("294", "MK")
        put("646", "MG")
        put("650", "MW")
        put("502", "MY")
        put("472", "MV")
        put("610", "ML")
        put("278", "MT")
        put("551", "MH")
        put("340", "MQ")
        put("609", "MR")
        put("617", "MU")
        put("334", "MX")
        put("550", "FM")
        put("259", "MD")
        put("212", "MC")
        put("428", "MN")
        put("297", "ME")
        put("354", "MS")
        put("604", "MA")
        put("643", "MZ")
        put("414", "MM")
        put("649", "NA")
        put("536", "NR")
        put("429", "NP")
        put("204", "NL")
        put("546", "NC")
        put("530", "NZ")
        put("710", "NI")
        put("614", "NE")
        put("621", "NG")
        put("555", "NU")
        put("505", "NF")
        put("310", "MP")
        put("242", "NO")
        put("422", "OM")
        put("410", "PK")
        put("552", "PW")
        put("425", "PS")
        put("714", "PA")
        put("537", "PG")
        put("744", "PY")
        put("716", "PE")
        put("515", "PH")
        put("260", "PL")
        put("268", "PT")
        put("330", "PR")
        put("427", "QA")
        put("226", "RO")
        put("250", "RU")
        put("635", "RW")
        put("340", "BL")
        put("658", "SH")
        put("356", "KN")
        put("358", "LC")
        put("340", "MF")
        put("308", "PM")
        put("360", "VC")
        put("549", "WS")
        put("292", "SM")
        put("626", "ST")
        put("420", "SA")
        put("608", "SN")
        put("220", "RS")
        put("633", "SC")
        put("619", "SL")
        put("525", "SG")
        put("362", "SX")
        put("231", "SK")
        put("293", "SI")
        put("540", "SB")
        put("637", "SO")
        put("655", "ZA")
        put("659", "SS")
        put("214", "ES")
        put("413", "LK")
        put("634", "SD")
        put("746", "SR")
        put("653", "SZ")
        put("240", "SE")
        put("228", "CH")
        put("417", "SY")
        put("466", "TW")
        put("436", "TJ")
        put("640", "TZ")
        put("520", "TH")
        put("615", "TG")
        put("554", "TK")
        put("539", "TO")
        put("374", "TT")
        put("605", "TN")
        put("286", "TR")
        put("438", "TM")
        put("376", "TC")
        put("553", "TV")
        put("641", "UG")
        put("255", "UA")
        put("424", "AE")
        put("430", "AE")
        put("431", "AE")
        put("234", "GB")
        put("235", "GB")
        put("310", "US")
        put("311", "US")
        put("312", "US")
        put("313", "US")
        put("314", "US")
        put("315", "US")
        put("316", "US")
        put("332", "VI")
        put("748", "UY")
        put("434", "UZ")
        put("541", "VU")
        put("734", "VE")
        put("452", "VN")
        put("543", "WF")
        put("421", "YE")
        put("645", "ZM")
        put("648", "ZW")
    }

    fun getByMcc(mcc: String) = map[mcc]
}