/*
 * Decompiled with CFR 0.152.
 */
package app.opendocument.android.pdf2htmlex;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import app.opendocument.android.pdf2htmlex.EnvVar;
import app.opendocument.android.pdf2htmlex.FontconfigAndroid;
import app.opendocument.android.pdf2htmlex.LegacyCleanup;
import app.opendocument.android.pdf2htmlex.NativeConverter;
import com.getkeepsafe.relinker.ReLinker;
import com.viliussutkus89.android.assetextractor.AssetExtractor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class pdf2htmlEX
implements Closeable {
    private final NativeConverter nc;
    private static final Object s_initSynchronizer = new Object();
    private final File mOutputDir;
    private File mDestinationDir;
    private String mOutputFilename;
    private File mInputPdf;
    private boolean mUserPasswordEntered;
    private boolean mOwnerPasswordEntered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public pdf2htmlEX(@NonNull Context ctx) {
        ReLinker.recursively().loadLibrary(ctx, "pdf2htmlEX-android");
        AssetExtractor ae = new AssetExtractor(ctx.getAssets()).setNoOverwrite();
        File filesDir = new File(ctx.getFilesDir(), "pdf2htmlEX");
        File cacheDir = new File(ctx.getCacheDir(), "pdf2htmlEX");
        File pdf2htmlEX_tmpDir = new File(cacheDir, "pdf2htmlEX-tmp");
        this.mOutputDir = new File(cacheDir, "output-htmls");
        File fontforgeHome = new File(cacheDir, "FontforgeHome");
        File envTMPDIR = new File(cacheDir, "envTMPDIR");
        Object object = s_initSynchronizer;
        synchronized (object) {
            LegacyCleanup.cleanup(ctx);
            cacheDir.mkdir();
            File pdf2htmlEX_dataDir = ae.extract(new File(filesDir, "share"), "pdf2htmlEX");
            File poppler_dataDir = ae.extract(new File(filesDir, "share"), "poppler-data");
            pdf2htmlEX_tmpDir.mkdir();
            this.mOutputDir.mkdir();
            fontforgeHome.mkdir();
            EnvVar.set("HOME", fontforgeHome.getAbsolutePath());
            envTMPDIR.mkdir();
            EnvVar.set("TMPDIR", envTMPDIR.getAbsolutePath());
            FontconfigAndroid.init(ctx.getAssets(), cacheDir, filesDir);
            EnvVar.set("USER", Build.MODEL);
            this.nc = new NativeConverter(pdf2htmlEX_tmpDir, pdf2htmlEX_dataDir, poppler_dataDir);
        }
    }

    @Override
    public void close() {
        this.nc.close();
    }

    private static String generateOutputFilenameWithoutExt(String inputFilename) {
        if (inputFilename.endsWith(".pdf")) {
            return inputFilename.substring(0, inputFilename.length() - 4);
        }
        return inputFilename;
    }

    private static String generateOutputFilename(String inputFilename) {
        return pdf2htmlEX.generateOutputFilenameWithoutExt(inputFilename) + ".html";
    }

    private static File generateOutputSubDirectory(File outputDir, String inputFilename) {
        String outputFilenameNoExt = pdf2htmlEX.generateOutputFilenameWithoutExt(inputFilename);
        File outputSubDir = new File(outputDir, outputFilenameNoExt);
        int i = 2;
        while (!outputSubDir.mkdir()) {
            outputSubDir = new File(outputDir, outputFilenameNoExt + "-" + i);
            ++i;
        }
        return outputSubDir;
    }

    public File convert() throws IOException, ConversionFailedException {
        File inputPdf = this.mInputPdf;
        if (null == inputPdf) {
            throw new ConversionFailedException("No Input PDF given!");
        }
        if (!inputPdf.exists()) {
            throw new FileNotFoundException();
        }
        NativeConverter.setInputFile(this.nc.mConverter, inputPdf.getAbsolutePath());
        String outputFilename = this.mOutputFilename;
        File destinationDir = this.mDestinationDir;
        if (null == outputFilename) {
            outputFilename = pdf2htmlEX.generateOutputFilename(inputPdf.getName());
        }
        if (null == destinationDir) {
            destinationDir = pdf2htmlEX.generateOutputSubDirectory(this.mOutputDir, inputPdf.getName());
        }
        File outputFile = new File(destinationDir, outputFilename);
        NativeConverter.setOutputFilename(this.nc.mConverter, outputFilename);
        NativeConverter.setDestinationDir(this.nc.mConverter, destinationDir.getAbsolutePath());
        int retVal = NativeConverter.convert(this.nc.mConverter);
        if (0 == retVal) {
            return outputFile;
        }
        outputFile.delete();
        if (null == this.mDestinationDir && destinationDir.exists() && destinationDir.isDirectory()) {
            File[] outputFiles = destinationDir.listFiles();
            if (outputFiles != null) {
                for (File i : outputFiles) {
                    i.delete();
                }
            }
            destinationDir.delete();
        }
        switch (retVal) {
            case 2: {
                if (!this.mUserPasswordEntered && !this.mOwnerPasswordEntered) {
                    throw new PasswordRequiredException("Password is required to decrypt this encrypted document!");
                }
                throw new WrongPasswordException("Wrong password is supplied to decrypt this encrypted document!");
            }
            case 3: {
                throw new CopyProtectionException("Document is copy protected!");
            }
        }
        throw new ConversionFailedException("Return value from pdf2htmlEX: " + retVal);
    }

    public File convert(@NonNull File inputPDF) throws IOException, ConversionFailedException {
        this.setInputPDF(inputPDF);
        return this.convert();
    }

    public pdf2htmlEX setInputPDF(@Nullable File inputPDF) {
        this.mInputPdf = inputPDF;
        return this;
    }

    public pdf2htmlEX setOutputHtml(@Nullable File outputHtml) {
        File destinationDir = null;
        String filename = null;
        if (null != outputHtml) {
            destinationDir = outputHtml.getAbsoluteFile().getParentFile();
            filename = outputHtml.getName();
        }
        return this.setDestinationDir(destinationDir).setOutputFilename(filename);
    }

    public pdf2htmlEX setOutputFilename(@Nullable String outputFilename) {
        this.mOutputFilename = outputFilename;
        return this;
    }

    public pdf2htmlEX setFirstPage(int firstPage) {
        NativeConverter.setFirstPage(this.nc.mConverter, firstPage);
        return this;
    }

    public pdf2htmlEX setLastPage(int lastPage) {
        NativeConverter.setLastPage(this.nc.mConverter, lastPage);
        return this;
    }

    public pdf2htmlEX setZoomRatio(double zoomRatio) {
        NativeConverter.setZoomRatio(this.nc.mConverter, zoomRatio);
        return this;
    }

    public pdf2htmlEX setFitWidth(double fitWidth) {
        NativeConverter.setFitWidth(this.nc.mConverter, fitWidth);
        return this;
    }

    public pdf2htmlEX setFitHeight(double fitHeight) {
        NativeConverter.setFitHeight(this.nc.mConverter, fitHeight);
        return this;
    }

    public pdf2htmlEX setUseCropBox(boolean useCropBox) {
        NativeConverter.setUseCropBox(this.nc.mConverter, useCropBox);
        return this;
    }

    public pdf2htmlEX setDPI(double desiredDPI) {
        NativeConverter.setDPI(this.nc.mConverter, desiredDPI);
        return this;
    }

    public pdf2htmlEX setEmbedCSS(boolean embedCSS) {
        NativeConverter.setEmbedCSS(this.nc.mConverter, embedCSS);
        return this;
    }

    public pdf2htmlEX setEmbedFont(boolean embedFont) {
        NativeConverter.setEmbedFont(this.nc.mConverter, embedFont);
        return this;
    }

    public pdf2htmlEX setEmbedImage(boolean embedImage) {
        NativeConverter.setEmbedImage(this.nc.mConverter, embedImage);
        return this;
    }

    public pdf2htmlEX setEmbedJavascript(boolean embedJavascript) {
        NativeConverter.setEmbedJavascript(this.nc.mConverter, embedJavascript);
        return this;
    }

    public pdf2htmlEX setEmbedOutline(boolean embedOutline) {
        NativeConverter.setEmbedOutline(this.nc.mConverter, embedOutline);
        return this;
    }

    public pdf2htmlEX setSplitPages(boolean splitPages) {
        NativeConverter.setSplitPages(this.nc.mConverter, splitPages);
        return this;
    }

    public pdf2htmlEX setDestinationDir(@Nullable File destinationDir) {
        this.mDestinationDir = destinationDir;
        return this;
    }

    public pdf2htmlEX setCSSFilename(@Nullable String cssFilename) {
        NativeConverter.setCSSFilename(this.nc.mConverter, cssFilename);
        return this;
    }

    public pdf2htmlEX setPageFilename(@Nullable String pageFilename) {
        NativeConverter.setPageFilename(this.nc.mConverter, pageFilename);
        return this;
    }

    public pdf2htmlEX setOutlineFilename(@Nullable String outlineFilename) {
        NativeConverter.setOutlineFilename(this.nc.mConverter, outlineFilename);
        return this;
    }

    public pdf2htmlEX setProcessNonText(boolean processNonText) {
        NativeConverter.setProcessNonText(this.nc.mConverter, processNonText);
        return this;
    }

    public pdf2htmlEX setProcessOutline(boolean processOutline) {
        NativeConverter.setProcessOutline(this.nc.mConverter, processOutline);
        return this;
    }

    public pdf2htmlEX setProcessAnnotation(boolean processAnnotation) {
        NativeConverter.setProcessAnnotation(this.nc.mConverter, processAnnotation);
        return this;
    }

    public pdf2htmlEX setProcessForm(boolean processForm) {
        NativeConverter.setProcessForm(this.nc.mConverter, processForm);
        return this;
    }

    public pdf2htmlEX setPrinting(boolean printing) {
        NativeConverter.setPrinting(this.nc.mConverter, printing);
        return this;
    }

    public pdf2htmlEX setFallback(boolean fallback) {
        NativeConverter.setFallback(this.nc.mConverter, fallback);
        return this;
    }

    public pdf2htmlEX setEmbedExternalFont(boolean embedExternalFont) {
        NativeConverter.setEmbedExternalFont(this.nc.mConverter, embedExternalFont);
        return this;
    }

    public pdf2htmlEX setFontFormat(String fontFormat) {
        NativeConverter.setFontFormat(this.nc.mConverter, fontFormat);
        return this;
    }

    public pdf2htmlEX setDecomposeLigature(boolean decomposeLigature) {
        NativeConverter.setDecomposeLigature(this.nc.mConverter, decomposeLigature);
        return this;
    }

    public pdf2htmlEX setAutoHint(boolean autoHint) {
        NativeConverter.setAutoHint(this.nc.mConverter, autoHint);
        return this;
    }

    public pdf2htmlEX setStretchNarrowGlyph(boolean stretchNarrowGlyph) {
        NativeConverter.setStretchNarrowGlyph(this.nc.mConverter, stretchNarrowGlyph);
        return this;
    }

    public pdf2htmlEX setSqueezeWideGlyph(boolean squeezeWideGlyph) {
        NativeConverter.setSqueezeWideGlyph(this.nc.mConverter, squeezeWideGlyph);
        return this;
    }

    public pdf2htmlEX setOverrideFstype(boolean overrideFSType) {
        NativeConverter.setOverrideFstype(this.nc.mConverter, overrideFSType);
        return this;
    }

    public pdf2htmlEX setProcessType3(boolean processType3) {
        NativeConverter.setProcessType3(this.nc.mConverter, processType3);
        return this;
    }

    public pdf2htmlEX setHorizontalEpsilon(double horizontalEpsilon) {
        NativeConverter.setHorizontalEpsilon(this.nc.mConverter, horizontalEpsilon);
        return this;
    }

    public pdf2htmlEX setVerticalEpsilon(double verticalEpsilon) {
        NativeConverter.setVerticalEpsilon(this.nc.mConverter, verticalEpsilon);
        return this;
    }

    public pdf2htmlEX setSpaceThreshold(double spaceThreshold) {
        NativeConverter.setSpaceThreshold(this.nc.mConverter, spaceThreshold);
        return this;
    }

    public pdf2htmlEX setFontSizeMultiplier(double fontSizeMultiplier) {
        NativeConverter.setFontSizeMultiplier(this.nc.mConverter, fontSizeMultiplier);
        return this;
    }

    public pdf2htmlEX setSpaceAsOffset(boolean spaceAsOffset) {
        NativeConverter.setSpaceAsOffset(this.nc.mConverter, spaceAsOffset);
        return this;
    }

    public pdf2htmlEX setToUnicode(ToUnicodeCMapsHandler toUnicode) {
        NativeConverter.setToUnicode(this.nc.mConverter, toUnicode.getInt());
        return this;
    }

    public pdf2htmlEX setOptimizeText(boolean optimizeText) {
        NativeConverter.setOptimizeText(this.nc.mConverter, optimizeText);
        return this;
    }

    public pdf2htmlEX setCorrectTextVisibility(TextVisibilityCorrection textVisibilityCorrection) {
        NativeConverter.setCorrectTextVisibility(this.nc.mConverter, textVisibilityCorrection.getInt());
        return this;
    }

    public pdf2htmlEX setCoveredTextDPI(double coveredTextDPI) {
        NativeConverter.setCoveredTextDPI(this.nc.mConverter, coveredTextDPI);
        return this;
    }

    public pdf2htmlEX setBackgroundImageFormat(BackgroundImageFormat backgroundImageFormat) {
        NativeConverter.setBackgroundImageFormat(this.nc.mConverter, backgroundImageFormat.toString());
        return this;
    }

    public pdf2htmlEX setSVGNodeCountLimit(int SVGNodeCountLimit) {
        NativeConverter.setSVGNodeCountLimit(this.nc.mConverter, SVGNodeCountLimit);
        return this;
    }

    public pdf2htmlEX setOwnerPassword(@Nullable String ownerPassword) {
        NativeConverter.setOwnerPassword(this.nc.mConverter, ownerPassword);
        this.mOwnerPasswordEntered = ownerPassword != null && !ownerPassword.isEmpty();
        return this;
    }

    public pdf2htmlEX setUserPassword(@Nullable String userPassword) {
        NativeConverter.setUserPassword(this.nc.mConverter, userPassword);
        this.mUserPasswordEntered = userPassword != null && !userPassword.isEmpty();
        return this;
    }

    public pdf2htmlEX setDRM(boolean enableDrm) {
        NativeConverter.setDrm(this.nc.mConverter, enableDrm);
        return this;
    }

    public pdf2htmlEX setDebug(boolean debug) {
        NativeConverter.setDebug(this.nc.mConverter, debug);
        return this;
    }

    public pdf2htmlEX setProof(boolean proof) {
        NativeConverter.setProof(this.nc.mConverter, proof);
        return this;
    }

    public pdf2htmlEX setQuiet(boolean quiet) {
        NativeConverter.setQuiet(this.nc.mConverter, quiet);
        return this;
    }

    public static class ConversionFailedException
    extends Exception {
        public ConversionFailedException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class PasswordRequiredException
    extends ConversionFailedException {
        public PasswordRequiredException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class WrongPasswordException
    extends ConversionFailedException {
        public WrongPasswordException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class CopyProtectionException
    extends ConversionFailedException {
        public CopyProtectionException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static enum ToUnicodeCMapsHandler {
        AUTO(0),
        FORCE(1),
        IGNORE(-1);

        private final int value;

        private ToUnicodeCMapsHandler(int value) {
            this.value = value;
        }

        int getInt() {
            return this.value;
        }
    }

    public static enum TextVisibilityCorrection {
        NO(0),
        FULL(1),
        PARTIAL(2);

        private final int value;

        private TextVisibilityCorrection(int value) {
            this.value = value;
        }

        int getInt() {
            return this.value;
        }
    }

    public static enum BackgroundImageFormat {
        PNG("png"),
        JPG("jpg"),
        SVG("svg");

        private final String value;

        private BackgroundImageFormat(String value) {
            this.value = value;
        }

        @NonNull
        public String toString() {
            return this.value;
        }
    }
}

