package app.peac.core.model.javafx.table;

import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;

public abstract class ClickableTableRow<T> extends TableRow<T> {

    protected ClickableTableRow() {
        super();

        this.setOnMouseClicked(event -> {
            if (this.isEmpty())
                return;

            switch (event.getButton()) {
                case PRIMARY -> processPrimaryButtonClick(event);
                case MIDDLE -> processMiddleButtonClick(event);
                case SECONDARY -> processSecondaryButtonClick(event);
            }
        });
    }

    private void processPrimaryButtonClick(MouseEvent event) {
        if (event.getClickCount() > 1) {
            fireDoubleClickEvent(this.getItem());
        } else {
            fireOneClickEvent(this.getItem());
        }
    }

    private void processMiddleButtonClick(MouseEvent event) {
        fireMiddleButtonClickEvent(this.getItem());
    }

    private void processSecondaryButtonClick(MouseEvent event) {
        fireRightButtonClickEvent(this.getItem());
    }

    protected void fireOneClickEvent(T item) {
    }

    protected void fireDoubleClickEvent(T item) {
    }

    protected void fireMiddleButtonClickEvent(T item) {
    }

    protected void fireRightButtonClickEvent(T item) {
    }
}
