package app.peac.core.utils.io;

import lombok.experimental.UtilityClass;

import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@UtilityClass
public class ZipHelper {

    private static final int BUFFER_SIZE = 4096;

    public static void unzip(byte[] data, String dirName) throws IOException {
        var destDir = new File(dirName);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (var zipIn = new ZipInputStream(new ByteArrayInputStream(data))) {
            ZipEntry entry = zipIn.getNextEntry();

            while (entry != null) {
                String filePath = dirName + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    extractFile(zipIn, filePath);
                } else {
                    var dir = new File(filePath);
                    dir.mkdirs();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (var bos = new BufferedOutputStream(new FileOutputStream(filePath))) {
            var bytesIn = new byte[BUFFER_SIZE];
            var read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }
}