package app.peac.core.utils.rpa.driver;

import app.peac.core.model.rpa.RpaDriverConfig;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;

@Slf4j
@UtilityClass
public class EdgeDriverUtils {

    public static WebDriver createEdgeDriver(RpaDriverConfig config) {
        log.info("Creating EdgeDriver");
        log.info("UserDataPath: {}", config.getUserDataPath());
        log.info("RunHeadless: {}", config.isRunHeadless());

        var options = new EdgeOptions();
        options.addArguments(ChromiumDriverUtils.getCommonDriverOptions());

        if (config.isUserDataExists()) {
            options.addArguments("user-data-dir=" + config.getUserDataPath());
        }

        if (config.isRunHeadless()) {
            options.addArguments("--headless");
        } else {
            options.addArguments("--start-maximized");
        }

        log.info("Edge Driver Options are ready");

        return new EdgeDriver(options);
    }
}
