/*
 * Decompiled with CFR 0.152.
 */
package app.pickmaven.businessdays;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class TemporalRange {
    private LocalDate startingDate;
    private LocalDate endingDate;

    private TemporalRange() {
    }

    public LocalDate getStartingDate() {
        return this.startingDate;
    }

    private void setStartingDate(LocalDate startingDate) {
        this.startingDate = startingDate;
    }

    public LocalDate getEndingDate() {
        return this.endingDate;
    }

    private void setEndingDate(LocalDate endingDate) {
        this.endingDate = endingDate;
    }

    public boolean includes(TemporalRange range) {
        assert (range != null) : "range must not be null";
        return this.startingDate.isBefore(range.getStartingDate()) && this.endingDate.isAfter(range.getEndingDate());
    }

    public boolean includes(LocalDate date) {
        assert (date != null) : "date must not be null";
        return date.isAfter(this.startingDate) && date.isBefore(this.getEndingDate());
    }

    public int hashCode() {
        return Objects.hash(this.getStartingDate(), this.getEndingDate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporalRange that = (TemporalRange)o;
        return this.getStartingDate().equals(that.getStartingDate()) && this.getEndingDate().equals(that.getEndingDate());
    }

    public String toString() {
        return "app.pickmaven.businessdays.TemporalRange{startingDate=" + this.startingDate + ", endingDate=" + this.endingDate + '}';
    }

    public static class Builder {
        private TemporalRange tRange = new TemporalRange();

        public static Builder aTemporalRange() {
            return new Builder();
        }

        public Builder from(LocalDate date) {
            assert (date != null) : "date must not be null";
            this.tRange.setStartingDate(date);
            return this;
        }

        public Builder from(String date, String pattern) {
            assert (date != null) : "date must not be null";
            assert (pattern != null) : "pattern must not be null";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            this.tRange.setStartingDate(LocalDate.parse(date, formatter));
            return this;
        }

        public Builder to(LocalDate date) {
            this.tRange.setEndingDate(date);
            return this;
        }

        public Builder to(String date, String pattern) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            this.tRange.setEndingDate(LocalDate.parse(date, formatter));
            return this;
        }

        public TemporalRange build() {
            assert (this.tRange.startingDate != null) : "Starting date must not be null";
            assert (this.tRange.endingDate != null) : "Ending date must not be null";
            return this.tRange;
        }
    }
}

