package app.pivo.android.lightsdk

import android.content.Context
import app.pivo.android.lightsdk.controller.ble.LightDevice
import app.pivo.android.lightsdk.controller.light.LightControllerImpl
import app.pivo.android.lightsdk.model.Brightness
import app.pivo.android.lightsdk.model.DeviceInfo
import app.pivo.android.lightsdk.model.LightPattern
import app.pivo.android.lightsdk.reply.ReplyHandler

/**
 * Created by murodjon on 2021/08/27
 */
class LightSdk constructor(context: Context) {

    private var controller = LightControllerImpl(context, ReplyHandler())

    companion object {
        private var instance: LightSdk? = null

        fun init(context: Context) {
            instance = LightSdk(context)
        }

        fun getInstance(): LightSdk {
            return instance!!
        }
    }

    /**
     * This function is used to scan for PodX
     */
    fun scan() {
        controller.scan()
    }

    /**
     * This function is used to connect to the device.
     * @param device is the LightDevice, you want to connect to
     */
    fun connectTo(device: LightDevice) {
        controller.connectTo(device)
    }

    /**
     * Call this function to stop scanning
     */
    fun cancelScan() {
        controller.stopScan()
    }

    /**
     * Call this function to disconnect
     */
    fun disconnect() {
        controller.disconnect()
    }

    /**
     * This function is used to check if the device is connected to headset
     */
    fun isConnected() = controller.isConnected()

    /**
     * This function is used to get name
     */
    fun getName() = controller.getName()


    /**
     * This function is used to change PodX name
     * @param name is desired
     */
    fun changeName(name: String) {
        controller.changeName(name)
    }

    /**
     * This function is used to get device info
     */
    fun getDeviceInfo() {
        controller.getDeviceInfo()
    }

    /**
     * This function is used to request battery
     */
    fun requestBatteryLevel() {
        controller.requestBatteryLevel()
    }

    /**
     * This functions is used request macAddress of headset
     */
    fun requestMacAddress() {
        controller.requestMacAddress()
    }

    /**
     * This function is used to request serial number of headset
     */
    fun requestSerialNumber() {
        controller.requestSerialNumber()
    }

    /**
     * This function is used to stop light preset
     */
    fun stopLightPreset() {
        controller.stopLightPreset()
    }

    /**
     * This function is used to run light preset
     *
     */
    fun runLightPreset(
        brightness: Brightness,
        interval: Double,
        patternType: LightPattern
    ) {
        controller.runLightPreset(brightness, interval, patternType)
    }

    /**
     * This [getBrightnessLevel] function is used to get brightness level
     */
    fun getBrightnessLevel() {
        controller.getBrightnessLevel()
    }

    /**
     * This [turnOffLight] function is used to turn off light
     */
    fun turnOffLight() {
        controller.turnOffLight()
    }

    /**
     * This [turnOnLight] function is used to turn on light
     * @param brightness holds warm and cool brightness level
     */
    fun turnOnLight(brightness: Brightness) {
        controller.turnOnLight(brightness)
    }

    /**
     * This function [dimSmoothly] is used to dim smoothly
     * @param brightness holds warm and cool brightness level
     */
    fun dimSmoothly(brightness: Brightness) {
        controller.dimSmoothly(brightness)
    }

    /**
     * This function [flash1X] function is used to flash
     * @param brightness holds warm and cool brightness level
     */
    fun flash1X(brightness: Brightness) {
        controller.flash1X(brightness)
    }
}