package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.Battery
import app.pivo.android.lightsdk.reply.Reply

/**
 * Created by murodjon on 2021/08/29
 */
internal class BatteryReply(private val bytes: ByteArray) : Reply<Battery> {
    override fun getData() = Battery(bytes[5].toInt())

    companion object {
        fun isBatteryReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0x04.toByte()
    }
}