package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.Flash
import app.pivo.android.lightsdk.reply.Reply

/**
 * Created by murodjon on 2021/08/29
 */
class FlashReply(private val bytes: ByteArray) : Reply<Flash> {
    override fun getData(): Flash? {
        return if (isFlashReply(bytes)) {
            Flash(bytes[4].toInt(), bytes[5].toInt())
        } else {
            null
        }
    }

    companion object {
        fun isFlashReply(bytes: ByteArray) = bytes.size >= 6 && bytes[2] == 0x22.toByte()
    }
}