package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.LightOff
import app.pivo.android.lightsdk.reply.Reply

/**
 * Created by murodjon on 2021/08/29
 */
class LightOffReply(val bytes: ByteArray) : Reply<LightOff> {
    override fun getData(): LightOff? {
        return if (isLightOffReply(bytes)) {
            LightOff
        } else {
            null
        }
    }

    companion object {
        fun isLightOffReply(bytes: ByteArray) = bytes.size >= 6 && bytes[2] == 0x20.toByte()
    }
}