package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.MacAddress
import app.pivo.android.lightsdk.reply.Reply
import app.pivo.android.lightsdk.util.HexUtil


/**
 * Created by murodjon on 2021/08/29
 */
class MacAddressReply(private val bytes: ByteArray) : Reply<MacAddress> {

    override fun getData() = getMacAddress()?.let { MacAddress(it) }

    private fun getMacAddress(): String? {
        return if (isMacAddressReply(bytes)) {
            val sizeOfBytes = bytes.size
            HexUtil.convertHexToString(bytes.copyOfRange(3, sizeOfBytes))
        } else null
    }

    companion object {
        fun isMacAddressReply(bytes: ByteArray) =
            bytes.size >= 8 && bytes[2] == 0x1B.toByte()
    }
}