package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.LightPattern
import app.pivo.android.lightsdk.model.LightPreset
import app.pivo.android.lightsdk.reply.Reply

/**
 * Created by murodjon on 2021/08/29
 */
class RunPresetReply(private val bytes: ByteArray) : Reply<LightPreset> {
    override fun getData() = getLightPreset()

    private fun getLightPreset(): LightPreset? {
        return if (isRunPresetReply(bytes)) {
            intervalMap[bytes[5]]?.let {
                LightPreset(
                    getPatternType(bytes[4]),
                    it, bytes[6].toInt(), bytes[7].toInt()
                )
            }
        } else null
    }

    private fun getPatternType(byte: Byte): LightPattern = when (byte) {
        0x01.toByte() -> LightPattern.Type_1
        0x02.toByte() -> LightPattern.Type_2
        else -> LightPattern.Type_3
    }

    private val intervalMap = mapOf(
        0x01 to 0.1,
        0x02 to 0.2,
        0x03 to 0.3,
        0x04 to 0.4,
        0x05 to 0.5,
        0x06 to 0.6,
        0x07 to 0.7,
        0x08 to 0.8,
        0x09 to 0.9,
        0x0A.toByte() to 1.0,
        0x0B.toByte() to 2.0,
        0x0C.toByte() to 3.0,
        0x0D.toByte() to 4.0,
        0x0E.toByte() to 5.0,
        0x0F.toByte() to 6.0,
        0x10.toByte() to 7.0,
        0x11.toByte() to 8.0,
        0x12.toByte() to 9.0,
        0x13.toByte() to 10.0,
    )

    companion object {
        fun isRunPresetReply(bytes: ByteArray) =
            bytes.size >= 8 && bytes[2] == 0x31.toByte()
    }
}