package app.pivo.android.lightsdk.reply

import app.pivo.android.lightsdk.controller.ble.BluetoothControllerCallback
import app.pivo.android.lightsdk.model.LightDevice
import app.pivo.android.lightsdk.events.PivoEvent
import app.pivo.android.lightsdk.events.PivoEventBus
import app.pivo.android.lightsdk.reply.impl.*
import app.pivo.android.lightsdk.reply.impl.BatteryReply
import app.pivo.android.lightsdk.reply.impl.DeviceInfoReply
import app.pivo.android.lightsdk.util.HexUtil

/**
 * Created by murodjon on 2021/08/28
 */
class ReplyHandler : BluetoothControllerCallback {
    override fun onAddDevice(device: LightDevice) {
        PivoEventBus.publish(PivoEventBus.SCAN_DEVICE, device)
    }

    override fun onConnectionFailed() {
        PivoEventBus.publish(PivoEventBus.CONNECTION_FAILED, PivoEvent.ConnectionFailure())
    }

    override fun onConnectionEstablished() {
        PivoEventBus.publish(PivoEventBus.CONNECTION_COMPLETED, PivoEvent.ConnectionComplete())
    }

    override fun onNotificationReceived(bytes: ByteArray) {
        when (val reply = ReplyUtil.getType(bytes)) {
            is DeviceInfoReply -> {
                PivoEventBus.publish(PivoEventBus.DEVICE_PROFILE, reply.getData())
            }
            is BatteryReply -> {
                PivoEventBus.publish(PivoEventBus.BATTERY_LEVEL, reply.getData())
            }
            is MacAddressReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.DEVICE_PROFILE, it) }
            }
            is SerialNumberReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.DEVICE_PROFILE, it) }
            }
            is NameChangedReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.NAME_CHANGED, it) }
            }
            is RunPresetReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.LIGHT_CONTROL, it) }
            }
            is StopPresetReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.LIGHT_CONTROL, it) }
            }
            is LightOffReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.LIGHT_CONTROL, it) }
            }
            is LightOnReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.LIGHT_CONTROL, it) }
            }
            is FlashReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.LIGHT_CONTROL, it) }
            }
            is SmoothDimReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.LIGHT_CONTROL, it) }
            }
            is GetBrightnessReply -> {
                reply.getData()?.let { PivoEventBus.publish(PivoEventBus.LIGHT_CONTROL, it) }
            }
            else -> {
                PivoEventBus.publish(
                    PivoEventBus.INVALID_REPLY_RECEIVED, PivoEvent.InvalidReply(
                        HexUtil.convertHexToString(bytes)
                    )
                )
            }
        }
    }
}